/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.datalytics.geofence;

import android.app.IntentService;
import android.content.Intent;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import io.hengam.lib.datalytics.b.b;
import io.hengam.lib.datalytics.geofence.GeofenceException;
import io.hengam.lib.datalytics.messages.downstream.GeofenceMessage;
import io.hengam.lib.internal.ComponentNotAvailableException;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.messaging.ParcelParseException;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeUtils;
import io.hengam.lib.utils.log.Plog;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lio/hengam/lib/datalytics/geofence/GeofenceService;", "Landroid/app/IntentService;", "()V", "onHandleIntent", "", "intent", "Landroid/content/Intent;", "datalytics_release"})
public final class GeofenceService
extends IntentService {
    /*
     * WARNING - void declaration
     */
    protected final void onHandleIntent(@Nullable Intent intent) {
        try {
            void var1_1;
            SchedulersKt.cpuThread((Function0)((Function0)new Function0<Unit>((Intent)var1_1){
                final /* synthetic */ Intent a;

                public final /* synthetic */ Object invoke() {
                    Object object = this;
                    try {
                        b b2 = (b)HengamInternals.INSTANCE.getComponent(b.class);
                        if (b2 == null) {
                            throw (Throwable)new ComponentNotAvailableException("datalytics");
                        }
                        b b3 = b2;
                        object = GeofencingEvent.fromIntent((Intent)object.a);
                        if (object.hasError()) {
                            StringBuilder stringBuilder = new StringBuilder("Error received in geofence service: ");
                            a a2 = object;
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)a2), (String)"geofencingEvent");
                            Plog.INSTANCE.warn("Datalytics", "Geofence", stringBuilder.append(a2.getErrorCode()).toString(), new Pair[0]);
                        } else {
                            a a3 = object;
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)a3), (String)"geofencingEvent");
                            List list = a3.getTriggeringGeofences();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"geofencingEvent.triggeringGeofences");
                            for (Object object2 : (Iterable)list) {
                                Object object3;
                                Object object4;
                                String string;
                                io.hengam.lib.datalytics.geofence.a a4 = b3.h();
                                Geofence geofence = object2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)geofence, (String)"event");
                                Intrinsics.checkExpressionValueIsNotNull((Object)geofence.getRequestId(), (String)"event.requestId");
                                object2 = a4;
                                Intrinsics.checkParameterIsNotNull((Object)string, (String)"geofenceId");
                                GeofenceMessage geofenceMessage = (GeofenceMessage)((io.hengam.lib.datalytics.geofence.a)object2).b.get((Object)string);
                                if (geofenceMessage == null) {
                                    Plog.INSTANCE.error("Datalytics", "Geofence", (Throwable)new GeofenceException("Geofence triggered but geofence data is missing", null, 6), new Pair[]{TuplesKt.to((Object)"Id", (Object)string)});
                                    ((io.hengam.lib.datalytics.geofence.a)object2).a(string);
                                    continue;
                                }
                                Time time = TimeUtils.INSTANCE.now();
                                Time time2 = (Time)((io.hengam.lib.datalytics.geofence.a)object2).d.get((Object)string);
                                if (geofenceMessage.l != null && time2 != null && time.minus(time2).compareTo(geofenceMessage.l) < 0) {
                                    Plog.INSTANCE.debug("Datalytics", "Geofence", "Geofence triggered but will be prevented due to rate limit.", new Pair[]{TuplesKt.to((Object)"Id", (Object)string)});
                                    continue;
                                }
                                Integer n2 = (Integer)((io.hengam.lib.datalytics.geofence.a)object2).c.get((Object)string);
                                int n3 = n2 != null ? n2 : 0;
                                Integer n4 = geofenceMessage.k;
                                if (n4 != null) {
                                    object4 = n4;
                                    object3 = ((Number)n4).intValue() >= 0 ? object4 : null;
                                } else {
                                    object3 = object4 = null;
                                }
                                if (object3 != null && n3 >= (Integer)object4 - 1) {
                                    ((io.hengam.lib.datalytics.geofence.a)object2).a(string);
                                    if (Intrinsics.compare((int)n3, (int)((Integer)object4)) >= 0) {
                                        Plog.INSTANCE.debug("Datalytics", "Geofence", "Geofence triggered but it's trigger limit has been reached.", new Pair[]{TuplesKt.to((Object)"Id", (Object)string)});
                                        continue;
                                    }
                                }
                                object4 = (Map)((io.hengam.lib.datalytics.geofence.a)object2).c;
                                Integer n5 = n3 + 1;
                                object4.put(string, n5);
                                object4 = (Map)((io.hengam.lib.datalytics.geofence.a)object2).d;
                                n5 = time;
                                object4.put(string, n5);
                                Plog.INSTANCE.info("Datalytics", "Geofence", "Geofence has been triggered", new Pair[]{TuplesKt.to((Object)"Id", (Object)string), TuplesKt.to((Object)"Count", (Object)(n3 + 1))});
                                try {
                                    ((io.hengam.lib.datalytics.geofence.a)object2).e.handleLocalParcel(geofenceMessage.m, geofenceMessage.a);
                                }
                                catch (ParcelParseException parcelParseException) {
                                    Plog.INSTANCE.warn("Datalytics", "Geofence", "Could not parse geofence content", (Throwable)parcelParseException, new Pair[0]);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        Plog.INSTANCE.error("Datalytics", "Geofence", (Throwable)exception, new Pair[0]);
                    }
                    return Unit.INSTANCE;
                }
                {
                    this.a = intent;
                    super(0);
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            Plog.INSTANCE.error("Datalytics", "Geofence", throwable, new Pair[0]);
            return;
        }
    }

    public GeofenceService() {
        super("GeofenceIntentService");
    }
}

