/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.websocket;

import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.websocket.ClientWsFrame;
import io.helidon.websocket.ServerWsFrame;
import io.helidon.websocket.WsCloseException;
import io.helidon.websocket.WsFrame;
import io.helidon.websocket.WsOpCode;

abstract sealed class AbstractWsFrame
implements WsFrame
permits ServerWsFrame, ClientWsFrame {
    private final LazyValue<BufferData> unmaskedData;
    private final long payloadLength;
    private final boolean fin;
    private final boolean isPayload;
    private volatile WsOpCode opCode;

    protected AbstractWsFrame(LazyValue<BufferData> unmaskedData, long payloadLength, boolean fin, boolean isPayload, WsOpCode opCode) {
        this.unmaskedData = unmaskedData;
        this.payloadLength = payloadLength;
        this.fin = fin;
        this.opCode = opCode;
        this.isPayload = isPayload;
    }

    @Override
    public boolean fin() {
        return this.fin;
    }

    @Override
    public WsOpCode opCode() {
        return this.opCode;
    }

    @Override
    public long payloadLength() {
        return this.payloadLength;
    }

    @Override
    public BufferData payloadData() {
        return (BufferData)this.unmaskedData.get();
    }

    @Override
    public boolean isPayload() {
        return this.isPayload;
    }

    public void opCode(WsOpCode opCode) {
        this.opCode = opCode;
    }

    public String toString() {
        return String.valueOf((Object)this.opCode) + (this.fin ? " (last): \n" : ": \n") + ((BufferData)this.unmaskedData.get()).debugDataHex();
    }

    protected static FrameHeader readFrameHeader(DataReader reader, int maxFrameLength) {
        byte opCodeByte = reader.read();
        boolean fin = (opCodeByte & 0x80) != 0;
        int extensionFlags = opCodeByte & 0x70;
        if (extensionFlags != 0) {
            throw new WsCloseException("Extension flags defined where none should be", 1002);
        }
        WsOpCode opCode = WsOpCode.get(opCodeByte & 0xF);
        byte lenByte = reader.read();
        boolean masked = (lenByte & 0x80) != 0;
        int length = lenByte & 0x7F;
        long frameLength = length < 126 ? (long)length : (length == 126 ? (long)reader.readBuffer(2).readInt16() : reader.readBuffer(8).readLong());
        if (frameLength < 0L) {
            throw new WsCloseException("Negative payload length", 1002);
        }
        if (frameLength > (long)maxFrameLength) {
            throw new WsCloseException("Payload too large", 1009);
        }
        return new FrameHeader(opCode, fin, masked, length);
    }

    protected static BufferData readPayload(DataReader reader, FrameHeader header) {
        return reader.readBuffer(header.length());
    }

    protected static boolean isPayload(FrameHeader header) {
        WsOpCode opCode = header.opCode;
        return opCode == WsOpCode.BINARY || opCode == WsOpCode.TEXT;
    }

    protected record FrameHeader(WsOpCode opCode, boolean fin, boolean masked, int length) {
    }
}

