/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.Builder;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.api.WebClientCookieManager;
import io.helidon.webclient.spi.Protocol;
import io.helidon.webclient.spi.ProtocolConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.testing.junit5.DirectClientConnection;
import io.helidon.webserver.testing.junit5.DirectPeerInfo;
import io.helidon.webserver.testing.junit5.DirectSocket;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class DirectWebClient
implements WebClient {
    private final HttpRouting routing;
    private final WebClient webClient;
    private String clientHost;
    private int clientPort;
    private Principal clientTlsPrincipal;
    private Certificate[] clientTlsCertificates;
    private String serverHost;
    private int serverPort;
    private Principal serverTlsPrincipal;
    private Certificate[] serverTlsCertificates;
    private boolean isTls;
    private Router router;

    public DirectWebClient(HttpRouting.Builder routing) {
        this.routing = (HttpRouting)routing.build();
        this.webClient = ((WebClientConfig.Builder)WebClient.builder().baseUri("http://helidon-unit:65000")).build();
        this.router = (Router)((Router.Builder)Router.builder().addRouting((Builder)routing)).build();
    }

    public HttpClientRequest method(Method method) {
        if (this.clientHost == null) {
            this.clientHost = "localhost";
        }
        if (this.clientPort == 0) {
            this.clientPort = 64000;
        }
        if (this.serverPort == 0) {
            this.serverPort = 8080;
        }
        if (this.serverHost == null) {
            this.serverHost = "localhost";
        }
        DirectPeerInfo clientPeer = new DirectPeerInfo(InetSocketAddress.createUnresolved(this.clientHost, this.clientPort), this.clientHost, this.clientPort, Optional.ofNullable(this.clientTlsPrincipal), Optional.ofNullable(this.clientTlsCertificates));
        DirectPeerInfo localPeer = new DirectPeerInfo(InetSocketAddress.createUnresolved(this.serverHost, this.serverPort), this.serverHost, this.serverPort, Optional.ofNullable(this.serverTlsPrincipal), Optional.ofNullable(this.serverTlsCertificates));
        DirectSocket socket = DirectSocket.create(clientPeer, localPeer, this.isTls);
        return (HttpClientRequest)((HttpClientRequest)this.webClient.method(method)).connection((ClientConnection)new DirectClientConnection(socket, this.router));
    }

    public void closeResource() {
    }

    public WebClientConfig prototype() {
        return (WebClientConfig)this.webClient.prototype();
    }

    public <T, C extends ProtocolConfig> T client(Protocol<T, C> protocol, C protocolConfig) {
        throw new UnsupportedOperationException("Clients based on protocols cannot be used with DirectWebClient, please inject protocol specific direct clients directly.");
    }

    public <T, C extends ProtocolConfig> T client(Protocol<T, C> protocol) {
        throw new UnsupportedOperationException("Clients based on protocols cannot be used with DirectWebClient, please inject protocol specific direct clients directly.");
    }

    public ExecutorService executor() {
        return this.webClient.executor();
    }

    public WebClientCookieManager cookieManager() {
        return this.webClient.cookieManager();
    }

    public DirectWebClient setTls(boolean tls) {
        this.isTls = tls;
        return this;
    }

    public DirectWebClient clientHost(String clientHost) {
        this.clientHost = clientHost;
        return this;
    }

    public DirectWebClient clientPort(int clientPort) {
        this.clientPort = clientPort;
        return this;
    }

    public DirectWebClient clientTlsPrincipal(Principal clientTlsPrincipal) {
        this.clientTlsPrincipal = clientTlsPrincipal;
        return this;
    }

    public DirectWebClient clientTlsCertificates(Certificate[] clientTlsCertificates) {
        this.clientTlsCertificates = clientTlsCertificates;
        return this;
    }

    public DirectWebClient serverHost(String serverHost) {
        this.serverHost = serverHost;
        return this;
    }

    public DirectWebClient serverPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public DirectWebClient serverTlsPrincipal(Principal serverTlsPrincipal) {
        this.serverTlsPrincipal = serverTlsPrincipal;
        return this;
    }

    public DirectWebClient serverTlsCertificates(Certificate[] serverTlsCertificates) {
        this.serverTlsCertificates = serverTlsCertificates;
        return this;
    }

    public void close() {
        this.router.afterStop();
    }
}

