/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.websocket;

import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.context.Context;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.PeerInfo;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.ListenerContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.http.DirectHandlers;
import java.util.concurrent.ExecutorService;

class DirectWsServerContext
implements ConnectionContext,
ListenerContext {
    private final ExecutorService executor;
    private final Router router;
    private final HelidonSocket socket;
    private final DataWriter dataWriter;
    private final DataReader dataReader;
    private final ListenerConfig listenerConfiguration;

    DirectWsServerContext(ExecutorService executor, Router router, HelidonSocket socket, DataWriter dataWriter, DataReader dataReader) {
        this.executor = executor;
        this.router = router;
        this.socket = socket;
        this.dataWriter = dataWriter;
        this.dataReader = dataReader;
        PeerInfo peerInfo = socket.localPeer();
        this.listenerConfiguration = ((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)ListenerConfig.builder().name("@default")).host(peerInfo.host())).port(peerInfo.port())).listenerContext(Context.builder().id("test-ws-direct-listener").build())).mediaContext(MediaContext.create())).contentEncoding(ContentEncodingContext.create())).directHandlers(DirectHandlers.create())).build();
    }

    public PeerInfo remotePeer() {
        return this.socket.remotePeer();
    }

    public PeerInfo localPeer() {
        return this.socket.localPeer();
    }

    public boolean isSecure() {
        return this.socket.isSecure();
    }

    public String socketId() {
        return this.socket.socketId();
    }

    public String childSocketId() {
        return this.socket.childSocketId();
    }

    public ListenerContext listenerContext() {
        return this;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public DataWriter dataWriter() {
        return this.dataWriter;
    }

    public DataReader dataReader() {
        return this.dataReader;
    }

    public Router router() {
        return this.router;
    }

    public Context context() {
        return (Context)this.listenerConfiguration.listenerContext().get();
    }

    public MediaContext mediaContext() {
        return (MediaContext)this.listenerConfiguration.mediaContext().get();
    }

    public ContentEncodingContext contentEncodingContext() {
        return (ContentEncodingContext)this.listenerConfiguration.contentEncoding().get();
    }

    public DirectHandlers directHandlers() {
        return (DirectHandlers)this.listenerConfiguration.directHandlers().get();
    }

    public ListenerConfig config() {
        return this.listenerConfiguration;
    }
}

