/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.websocket;

import io.helidon.webclient.websocket.WsClient;
import io.helidon.webclient.websocket.WsClientConfig;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.spi.ServerJunitExtension;
import io.helidon.webserver.websocket.WsRouting;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class WsServerExtension
implements ServerJunitExtension {
    public Optional<ServerJunitExtension.ParamHandler<?>> setUpRouteParamHandler(Class<?> type) {
        if (WsRouting.Builder.class.equals(type)) {
            return Optional.of(new RoutingParamHandler());
        }
        return Optional.empty();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return WsClient.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> parameterType, WebServer server) {
        String socketName = Junit5Util.socketName((Parameter)parameterContext.getParameter());
        if (WsClient.class.equals(parameterType)) {
            return ((WsClientConfig.Builder)WsClient.builder().baseUri("ws://localhost:" + server.port(socketName))).build();
        }
        throw new ParameterResolutionException("WebSocket extension only supports WsClient parameter type");
    }

    private static final class RoutingParamHandler
    implements ServerJunitExtension.ParamHandler<WsRouting.Builder> {
        private RoutingParamHandler() {
        }

        public WsRouting.Builder get(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder) {
            return WsRouting.builder();
        }

        public void handle(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder, WsRouting.Builder value) {
            routerBuilder.addRouting((Routing)value.build());
        }
    }
}

