/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.jsonrpc;

import io.helidon.webclient.jsonrpc.JsonRpcClient;
import io.helidon.webclient.jsonrpc.JsonRpcClientConfig;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.spi.ServerJunitExtension;
import java.lang.reflect.Parameter;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class JsonRpcServerExtension
implements ServerJunitExtension {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return JsonRpcClient.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> parameterType, WebServer server) {
        String socketName = Junit5Util.socketName((Parameter)parameterContext.getParameter());
        if (JsonRpcClient.class.equals(parameterType)) {
            return ((JsonRpcClientConfig.Builder)JsonRpcClient.builder().baseUri("http://localhost:" + server.port(socketName))).build();
        }
        throw new ParameterResolutionException("JSON-RPC extension only supports JsonRpcClient parameter type");
    }
}

