/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.grpc;

import io.helidon.common.Builder;
import io.helidon.webclient.grpc.GrpcClient;
import io.helidon.webclient.grpc.GrpcClientConfig;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.grpc.GrpcRouting;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.spi.ServerJunitExtension;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class GrpcServerExtension
implements ServerJunitExtension {
    public Optional<ServerJunitExtension.ParamHandler<?>> setUpRouteParamHandler(Class<?> type) {
        if (GrpcRouting.Builder.class.equals(type)) {
            return Optional.of(new RoutingParamHandler());
        }
        return Optional.empty();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return GrpcClient.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> parameterType, WebServer server) {
        String socketName = Junit5Util.socketName((Parameter)parameterContext.getParameter());
        if (GrpcClient.class.equals(parameterType)) {
            return ((GrpcClientConfig.Builder)GrpcClient.builder().baseUri("http://localhost:" + server.port(socketName))).build();
        }
        throw new ParameterResolutionException("gRPC extension only supports GrpcClient parameter type");
    }

    private static final class RoutingParamHandler
    implements ServerJunitExtension.ParamHandler<GrpcRouting.Builder> {
        private RoutingParamHandler() {
        }

        public GrpcRouting.Builder get(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder) {
            return GrpcRouting.builder();
        }

        public void handle(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder, GrpcRouting.Builder value) {
            routerBuilder.addRouting((Builder)value);
        }
    }
}

