/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.ForwardingHandler;
import io.helidon.webserver.HelidonConnectionHandler;
import io.helidon.webserver.Http2Configuration;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;

class HttpInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = Logger.getLogger(HttpInitializer.class.getName());
    static final AttributeKey<String> CERTIFICATE_NAME = AttributeKey.valueOf((String)"certificate_name");
    private final SslContext sslContext;
    private final NettyWebServer webServer;
    private final Routing routing;
    private final Queue<ReferenceHoldingQueue<DataChunk>> queues = new ConcurrentLinkedQueue<ReferenceHoldingQueue<DataChunk>>();

    HttpInitializer(SslContext sslContext, Routing routing, NettyWebServer webServer) {
        this.routing = routing;
        this.sslContext = sslContext;
        this.webServer = webServer;
    }

    private void clearQueues() {
        this.queues.removeIf(ReferenceHoldingQueue::release);
    }

    void queuesShutdown() {
        this.queues.removeIf(queue -> {
            queue.shutdown();
            return true;
        });
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        SSLEngine sslEngine = null;
        if (this.sslContext != null) {
            SslHandler sslHandler = this.sslContext.newHandler(ch.alloc());
            sslEngine = sslHandler.engine();
            p.addLast(new ChannelHandler[]{sslHandler});
            sslHandler.handshakeFuture().addListener(future -> this.obtainClientCN((Future<? super Channel>)future, ch, sslHandler));
        }
        ServerConfiguration serverConfig = this.webServer.configuration();
        HttpRequestDecoder requestDecoder = new HttpRequestDecoder();
        if (serverConfig.isHttp2Enabled()) {
            ExperimentalConfiguration experimental = serverConfig.experimental();
            Http2Configuration http2Config = experimental.http2();
            HttpServerCodec sourceCodec = new HttpServerCodec();
            HelidonConnectionHandler helidonHandler = new HelidonConnectionHandler.HelidonHttp2ConnectionHandlerBuilder().maxContentLength(http2Config.maxContentLength()).build();
            HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, protocol -> AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol) ? new Http2ServerUpgradeCodec((Http2ConnectionHandler)helidonHandler) : null, http2Config.maxContentLength());
            CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)helidonHandler);
            p.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
            p.addLast(new ChannelHandler[]{new HelidonEventLogger()});
        } else {
            p.addLast(new ChannelHandler[]{requestDecoder});
            p.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        }
        p.addLast(new ChannelHandler[]{new ForwardingHandler(this.routing, this.webServer, sslEngine, this.queues, requestDecoder)});
        ch.eventLoop().execute(this::clearQueues);
    }

    private void obtainClientCN(Future<? super Channel> future, SocketChannel ch, SslHandler sslHandler) {
        if (future.cause() == null) {
            try {
                Certificate[] peerCertificates = sslHandler.engine().getSession().getPeerCertificates();
                if (peerCertificates.length >= 1) {
                    int end;
                    Certificate certificate = peerCertificates[0];
                    X509Certificate cert = (X509Certificate)certificate;
                    Principal principal = cert.getSubjectDN();
                    int start = principal.getName().indexOf("CN=");
                    String tmpName = "Unknown CN";
                    if (start >= 0 && (end = (tmpName = principal.getName().substring(start + 3)).indexOf(",")) > 0) {
                        tmpName = tmpName.substring(0, end);
                    }
                    ch.attr(CERTIFICATE_NAME).set((Object)tmpName);
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
    }

    private static final class HelidonEventLogger
    extends ChannelInboundHandlerAdapter {
        private HelidonEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            LOGGER.finer(() -> "Event Triggered: " + evt);
            ctx.fireUserEventTriggered(evt);
        }
    }
}

