/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.FormParams;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Flow;

public class FormParamsSupport
implements Service,
Handler {
    private static final FormParamsSupport INSTANCE = new FormParamsSupport();

    @Override
    public void update(Routing.Rules rules) {
        rules.any(this);
    }

    @Override
    public void accept(ServerRequest req, ServerResponse res) {
        MediaType reqMediaType = req.headers().contentType().orElse(MediaType.TEXT_PLAIN);
        Charset charset = reqMediaType.charset().map(Charset::forName).orElse(StandardCharsets.UTF_8);
        req.content().registerReader(FormParams.class, (chunks, type) -> FormParamsSupport.readContent(reqMediaType, charset, chunks).map(s -> FormParams.create((String)s, (MediaType)reqMediaType)).toStage());
        req.next();
    }

    public static FormParamsSupport create() {
        return INSTANCE;
    }

    private static Single<String> readContent(MediaType mediaType, Charset charset, Flow.Publisher<DataChunk> chunks) {
        return mediaType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED) ? ContentReaders.readURLEncodedString(chunks, (Charset)charset) : ContentReaders.readString(chunks, (Charset)charset);
    }
}

