/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.Route;
import io.helidon.websocket.WsListener;
import java.util.function.Supplier;

public class WsRoute
implements Route {
    private final PathMatcher pathMatcher;
    private final Supplier<WsListener> listenerSupplier;

    private WsRoute(PathMatcher pathMatcher, Supplier<WsListener> listenerSupplier) {
        this.pathMatcher = pathMatcher;
        this.listenerSupplier = listenerSupplier;
    }

    static WsRoute create(String path, WsListener listener) {
        PathMatcher pathMatcher = PathMatchers.create((String)path);
        return new WsRoute(pathMatcher, () -> listener);
    }

    static WsRoute create(String path, Supplier<WsListener> listener) {
        PathMatcher pathMatcher = PathMatchers.create((String)path);
        return new WsRoute(pathMatcher, listener);
    }

    public WsListener listener() {
        return this.listenerSupplier.get();
    }

    PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        return this.pathMatcher.match(prologue.uriPath());
    }
}

