/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.webserver.ForwardingHandler;
import io.helidon.webserver.websocket.WebSocketHandler;
import io.helidon.webserver.websocket.WebSocketRouting;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class WebSocketUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodec {
    private static final Logger LOGGER = Logger.getLogger(WebSocketUpgradeCodec.class.getName());
    private final WebSocketRouting webSocketRouting;
    private String path;
    private WebSocketHandler wsHandler;

    WebSocketUpgradeCodec(WebSocketRouting webSocketRouting) {
        this.webSocketRouting = webSocketRouting;
    }

    public Collection<CharSequence> requiredUpgradeHeaders() {
        return List.of("Upgrade");
    }

    public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeResponseHeaders) {
        try {
            this.path = upgradeRequest.uri();
            upgradeResponseHeaders.remove("upgrade");
            upgradeResponseHeaders.remove("connection");
            this.wsHandler = new WebSocketHandler(ctx, this.path, upgradeRequest, upgradeResponseHeaders, this.webSocketRouting);
            return true;
        }
        catch (Throwable cause) {
            LOGGER.log(Level.SEVERE, "Error during upgrade to WebSocket", cause);
            return false;
        }
    }

    public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
        if (ctx.pipeline().get(ForwardingHandler.class) != null) {
            ctx.pipeline().remove(ForwardingHandler.class);
        }
        ctx.pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.path, null, true)});
        ctx.pipeline().addLast(new ChannelHandler[]{this.wsHandler});
        ctx.pipeline().remove("io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler");
        this.wsHandler.open(ctx);
    }
}

