/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.security.Security;
import io.helidon.webserver.security.PathsConfig;
import io.helidon.webserver.security.SecurityConfigSupport;
import io.helidon.webserver.security.SecurityFeature;
import io.helidon.webserver.security.SecurityFeatureConfigBlueprint;
import io.helidon.webserver.security.SecurityHandler;
import io.helidon.webserver.security.SecurityHandlerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.security.SecurityFeatureConfigBlueprint")
public interface SecurityFeatureConfig
extends SecurityFeatureConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SecurityFeatureConfig instance) {
        return (Builder)SecurityFeatureConfig.builder().from(instance);
    }

    public static SecurityFeatureConfig create(Config config) {
        return ((Builder)SecurityFeatureConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static SecurityFeatureConfig create(io.helidon.common.config.Config config) {
        return SecurityFeatureConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static SecurityFeatureConfig create() {
        return SecurityFeatureConfig.builder().buildPrototype();
    }

    @Override
    public double weight();

    @Override
    public SecurityHandler defaults();

    @Override
    public List<PathsConfig> paths();

    @Override
    public Security security();

    @Override
    public String name();

    public static class Builder
    extends BuilderBase<Builder, SecurityFeatureConfig>
    implements io.helidon.common.Builder<Builder, SecurityFeature> {
        private Builder() {
        }

        public SecurityFeatureConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SecurityFeatureConfigImpl(this);
        }

        public SecurityFeature build() {
            return SecurityFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SecurityFeatureConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<PathsConfig> paths = new ArrayList<PathsConfig>();
        private boolean isPathsMutated;
        private Config config;
        private double weight = 800.0;
        private Security security;
        private SecurityHandler defaults = SecurityHandler.create();
        private String name = "security";

        protected BuilderBase() {
        }

        public BUILDER from(SecurityFeatureConfig prototype) {
            this.weight(prototype.weight());
            this.defaults(prototype.defaults());
            if (!this.isPathsMutated) {
                this.paths.clear();
            }
            this.addPaths(prototype.paths());
            this.security(prototype.security());
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.weight(builder.weight());
            this.defaults(builder.defaults());
            if (this.isPathsMutated) {
                if (builder.isPathsMutated) {
                    this.addPaths(builder.paths);
                }
            } else {
                this.paths.clear();
                this.addPaths(builder.paths);
            }
            builder.security().ifPresent(this::security);
            this.name(builder.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("defaults").as(SecurityHandlerConfig::create).ifPresent(this::defaults);
            config.get("paths").asList(PathsConfig::create).ifPresent(this::paths);
            config.get("security").as(Security::create).ifPresent(this::security);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaults(SecurityHandler defaults) {
            Objects.requireNonNull(defaults);
            this.defaults = defaults;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaults(SecurityHandlerConfig defaultsConfig) {
            Objects.requireNonNull(defaultsConfig);
            this.defaults = SecurityHandler.create(defaultsConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaults(Consumer<SecurityHandlerConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SecurityHandlerConfig.Builder builder = SecurityHandlerConfig.builder();
            consumer.accept(builder);
            this.defaults(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaults(Supplier<? extends SecurityHandler> supplier) {
            Objects.requireNonNull(supplier);
            this.defaults(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER paths(List<? extends PathsConfig> paths) {
            Objects.requireNonNull(paths);
            this.isPathsMutated = true;
            this.paths.clear();
            this.paths.addAll(paths);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPaths(List<? extends PathsConfig> paths) {
            Objects.requireNonNull(paths);
            this.isPathsMutated = true;
            this.paths.addAll(paths);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPath(PathsConfig path) {
            Objects.requireNonNull(path);
            this.paths.add(path);
            this.isPathsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPath(Consumer<PathsConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            PathsConfig.Builder builder = PathsConfig.builder();
            consumer.accept(builder);
            this.paths.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER security(Security security) {
            Objects.requireNonNull(security);
            this.security = security;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER security(Consumer<Security.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Security.Builder builder = Security.builder();
            consumer.accept(builder);
            this.security(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER security(Supplier<? extends Security> supplier) {
            Objects.requireNonNull(supplier);
            this.security(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public double weight() {
            return this.weight;
        }

        public SecurityHandler defaults() {
            return this.defaults;
        }

        public List<PathsConfig> paths() {
            return this.paths;
        }

        public Optional<Security> security() {
            return Optional.ofNullable(this.security);
        }

        public String name() {
            return this.name;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "SecurityFeatureConfigBuilder{weight=" + this.weight + ",defaults=" + String.valueOf(this.defaults) + ",paths=" + String.valueOf(this.paths) + ",security=" + String.valueOf(this.security) + ",name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
            new SecurityConfigSupport.SecurityFeatureConfigDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.security == null) {
                collector.fatal(this.getClass(), "Property \"security\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class SecurityFeatureConfigImpl
        implements SecurityFeatureConfig,
        Supplier<SecurityFeature> {
            private final double weight;
            private final List<PathsConfig> paths;
            private final Security security;
            private final SecurityHandler defaults;
            private final String name;

            protected SecurityFeatureConfigImpl(BuilderBase<?, ?> builder) {
                this.weight = builder.weight();
                this.defaults = builder.defaults();
                this.paths = List.copyOf(builder.paths());
                this.security = builder.security().get();
                this.name = builder.name();
            }

            public SecurityFeature build() {
                return SecurityFeature.create(this);
            }

            @Override
            public SecurityFeature get() {
                return this.build();
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public SecurityHandler defaults() {
                return this.defaults;
            }

            @Override
            public List<PathsConfig> paths() {
                return this.paths;
            }

            @Override
            public Security security() {
                return this.security;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                return "SecurityFeatureConfig{weight=" + this.weight + ",defaults=" + String.valueOf(this.defaults) + ",paths=" + String.valueOf(this.paths) + ",security=" + String.valueOf(this.security) + ",name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SecurityFeatureConfig)) {
                    return false;
                }
                SecurityFeatureConfig other = (SecurityFeatureConfig)o;
                return this.weight == other.weight() && Objects.equals(this.defaults, other.defaults()) && Objects.equals(this.paths, other.paths()) && Objects.equals(this.security, other.security()) && Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.weight, this.defaults, this.paths, this.security, this.name);
            }
        }
    }
}

