/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.http.Method;
import io.helidon.webserver.security.PathsConfigBlueprint;
import io.helidon.webserver.security.SecurityHandler;
import io.helidon.webserver.security.SecurityHandlerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.security.PathsConfigBlueprint")
public interface PathsConfig
extends PathsConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PathsConfig instance) {
        return (Builder)PathsConfig.builder().from(instance);
    }

    public static PathsConfig create(Config config) {
        return ((Builder)PathsConfig.builder().config(config)).buildPrototype();
    }

    public static PathsConfig create() {
        return PathsConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, PathsConfig>
    implements io.helidon.common.Builder<Builder, PathsConfig> {
        private Builder() {
        }

        public PathsConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.PathsConfigImpl(this);
        }

        public PathsConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PathsConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<Method> methods = new ArrayList<Method>();
        private final List<String> sockets = new ArrayList<String>(List.of("@default"));
        private Config config;
        private SecurityHandler handler;
        private String path;

        protected BuilderBase() {
        }

        public BUILDER from(PathsConfig prototype) {
            this.addMethods(prototype.methods());
            this.path(prototype.path());
            this.addSockets(prototype.sockets());
            this.handler(prototype.handler());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addMethods(builder.methods());
            builder.path().ifPresent(this::path);
            this.addSockets(builder.sockets());
            builder.handler().ifPresent(this::handler);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("methods").mapList(PathsConfigBlueprint::createMethods).ifPresent(this::methods);
            config.get("path").as(String.class).ifPresent(this::path);
            config.get("sockets").asList(String.class).ifPresent(this::sockets);
            config.map(SecurityHandlerConfig::create).ifPresent(this::handler);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER methods(List<? extends Method> methods) {
            Objects.requireNonNull(methods);
            this.methods.clear();
            this.methods.addAll(methods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMethods(List<? extends Method> methods) {
            Objects.requireNonNull(methods);
            this.methods.addAll(methods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addMethod(Method method) {
            Objects.requireNonNull(method);
            this.methods.add(method);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER path(String path) {
            Objects.requireNonNull(path);
            this.path = path;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(List<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(List<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER handler(SecurityHandler handler) {
            Objects.requireNonNull(handler);
            this.handler = handler;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER handler(SecurityHandlerConfig handlerConfig) {
            Objects.requireNonNull(handlerConfig);
            this.handler = SecurityHandler.create(handlerConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER handler(Consumer<SecurityHandlerConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SecurityHandlerConfig.Builder builder = SecurityHandler.builder();
            consumer.accept(builder);
            this.handler(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER handler(Supplier<? extends SecurityHandler> supplier) {
            Objects.requireNonNull(supplier);
            this.handler(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<Method> methods() {
            return this.methods;
        }

        public Optional<String> path() {
            return Optional.ofNullable(this.path);
        }

        public List<String> sockets() {
            return this.sockets;
        }

        public Optional<SecurityHandler> handler() {
            return Optional.ofNullable(this.handler);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "PathsConfigBuilder{methods=" + String.valueOf(this.methods) + ",path=" + this.path + ",sockets=" + String.valueOf(this.sockets) + ",handler=" + String.valueOf(this.handler) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.path == null) {
                collector.fatal(this.getClass(), "Property \"path\" must not be null, but not set");
            }
            if (this.handler == null) {
                collector.fatal(this.getClass(), "Property \"handler\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class PathsConfigImpl
        implements PathsConfig {
            private final List<Method> methods;
            private final List<String> sockets;
            private final SecurityHandler handler;
            private final String path;

            protected PathsConfigImpl(BuilderBase<?, ?> builder) {
                this.methods = List.copyOf(builder.methods());
                this.path = builder.path().get();
                this.sockets = List.copyOf(builder.sockets());
                this.handler = builder.handler().get();
            }

            @Override
            public List<Method> methods() {
                return this.methods;
            }

            @Override
            public String path() {
                return this.path;
            }

            @Override
            public List<String> sockets() {
                return this.sockets;
            }

            @Override
            public SecurityHandler handler() {
                return this.handler;
            }

            public String toString() {
                return "PathsConfig{methods=" + String.valueOf(this.methods) + ",path=" + this.path + ",sockets=" + String.valueOf(this.sockets) + ",handler=" + String.valueOf(this.handler) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PathsConfig)) {
                    return false;
                }
                PathsConfig other = (PathsConfig)o;
                return Objects.equals(this.methods, other.methods()) && Objects.equals(this.path, other.path()) && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.handler, other.handler());
            }

            public int hashCode() {
                return Objects.hash(this.methods, this.path, this.sockets, this.handler);
            }
        }
    }
}

