/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ProtoMarshaller {
    private static final Map<Class<?>, MethodDescriptor.Marshaller<?>> CACHE = new ConcurrentHashMap();

    private ProtoMarshaller() {
    }

    static <T> MethodDescriptor.Marshaller<T> get(Class<T> clazz) {
        MethodDescriptor.Marshaller result = CACHE.get(clazz);
        if (result != null) {
            return result;
        }
        try {
            Method getDefaultInstance = clazz.getDeclaredMethod("getDefaultInstance", new Class[0]);
            Message instance = (Message)getDefaultInstance.invoke(clazz, new Object[0]);
            result = ProtoUtils.marshaller((Message)instance);
            MethodDescriptor.Marshaller current = CACHE.putIfAbsent(clazz, result);
            return current == null ? result : current;
        }
        catch (ReflectiveOperationException e) {
            String msg = "Attempting to use class \"" + clazz.getName() + "\", which is not a valid Protocol buffer message, with a default marshaller";
            throw new IllegalArgumentException(msg, e);
        }
    }
}

