/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.grpc.core.GrpcTracingName;
import io.helidon.webserver.grpc.GrpcTracingConfigBlueprint;
import io.helidon.webserver.grpc.ServerRequestAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.grpc.GrpcTracingConfigBlueprint")
public interface GrpcTracingConfig
extends GrpcTracingConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcTracingConfig instance) {
        return (Builder)GrpcTracingConfig.builder().from(instance);
    }

    public static GrpcTracingConfig create(Config config) {
        return ((Builder)GrpcTracingConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static GrpcTracingConfig create(io.helidon.common.config.Config config) {
        return GrpcTracingConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static GrpcTracingConfig create() {
        return GrpcTracingConfig.builder().buildPrototype();
    }

    @Override
    public boolean enabled();

    @Override
    public boolean verbose();

    @Override
    public boolean streaming();

    @Override
    public Optional<GrpcTracingName> operationNameConstructor();

    @Override
    public Set<ServerRequestAttribute> tracedAttributes();

    public static class Builder
    extends BuilderBase<Builder, GrpcTracingConfig>
    implements io.helidon.common.Builder<Builder, GrpcTracingConfig> {
        private Builder() {
        }

        public GrpcTracingConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcTracingConfigImpl(this);
        }

        public GrpcTracingConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcTracingConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Set<ServerRequestAttribute> tracedAttributes = new LinkedHashSet<ServerRequestAttribute>();
        private boolean enabled = true;
        private boolean streaming = false;
        private boolean verbose = false;
        private Config config;
        private GrpcTracingName operationNameConstructor;

        protected BuilderBase() {
        }

        public BUILDER from(GrpcTracingConfig prototype) {
            this.enabled(prototype.enabled());
            this.verbose(prototype.verbose());
            this.streaming(prototype.streaming());
            this.operationNameConstructor(prototype.operationNameConstructor());
            this.addTracedAttributes(prototype.tracedAttributes());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            this.verbose(builder.verbose());
            this.streaming(builder.streaming());
            builder.operationNameConstructor().ifPresent(this::operationNameConstructor);
            this.addTracedAttributes(builder.tracedAttributes);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("verbose").as(Boolean.class).ifPresent(this::verbose);
            config.get("streaming").as(Boolean.class).ifPresent(this::streaming);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER verbose(boolean verbose) {
            this.verbose = verbose;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER streaming(boolean streaming) {
            this.streaming = streaming;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOperationNameConstructor() {
            this.operationNameConstructor = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER operationNameConstructor(GrpcTracingName operationNameConstructor) {
            Objects.requireNonNull(operationNameConstructor);
            this.operationNameConstructor = operationNameConstructor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tracedAttributes(Set<? extends ServerRequestAttribute> tracedAttributes) {
            Objects.requireNonNull(tracedAttributes);
            this.tracedAttributes.clear();
            this.tracedAttributes.addAll(tracedAttributes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTracedAttributes(Set<? extends ServerRequestAttribute> tracedAttributes) {
            Objects.requireNonNull(tracedAttributes);
            this.tracedAttributes.addAll(tracedAttributes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTracedAttribute(ServerRequestAttribute tracedAttribute) {
            Objects.requireNonNull(tracedAttribute);
            this.tracedAttributes.add(tracedAttribute);
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean verbose() {
            return this.verbose;
        }

        public boolean streaming() {
            return this.streaming;
        }

        public Optional<GrpcTracingName> operationNameConstructor() {
            return Optional.ofNullable(this.operationNameConstructor);
        }

        public Set<ServerRequestAttribute> tracedAttributes() {
            return this.tracedAttributes;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcTracingConfigBuilder{enabled=" + this.enabled + ",verbose=" + this.verbose + ",streaming=" + this.streaming + ",operationNameConstructor=" + String.valueOf(this.operationNameConstructor) + ",tracedAttributes=" + String.valueOf(this.tracedAttributes) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER operationNameConstructor(Optional<? extends GrpcTracingName> operationNameConstructor) {
            Objects.requireNonNull(operationNameConstructor);
            this.operationNameConstructor = operationNameConstructor.map(GrpcTracingName.class::cast).orElse(this.operationNameConstructor);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class GrpcTracingConfigImpl
        implements GrpcTracingConfig {
            private final boolean enabled;
            private final boolean streaming;
            private final boolean verbose;
            private final Optional<GrpcTracingName> operationNameConstructor;
            private final Set<ServerRequestAttribute> tracedAttributes;

            protected GrpcTracingConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.verbose = builder.verbose();
                this.streaming = builder.streaming();
                this.operationNameConstructor = builder.operationNameConstructor().map(Function.identity());
                this.tracedAttributes = Collections.unmodifiableSet(new LinkedHashSet<ServerRequestAttribute>(builder.tracedAttributes()));
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public boolean verbose() {
                return this.verbose;
            }

            @Override
            public boolean streaming() {
                return this.streaming;
            }

            @Override
            public Optional<GrpcTracingName> operationNameConstructor() {
                return this.operationNameConstructor;
            }

            @Override
            public Set<ServerRequestAttribute> tracedAttributes() {
                return this.tracedAttributes;
            }

            public String toString() {
                return "GrpcTracingConfig{enabled=" + this.enabled + ",verbose=" + this.verbose + ",streaming=" + this.streaming + ",operationNameConstructor=" + String.valueOf(this.operationNameConstructor) + ",tracedAttributes=" + String.valueOf(this.tracedAttributes) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcTracingConfig)) {
                    return false;
                }
                GrpcTracingConfig other = (GrpcTracingConfig)o;
                return this.enabled == other.enabled() && this.verbose == other.verbose() && this.streaming == other.streaming() && Objects.equals(this.operationNameConstructor, other.operationNameConstructor()) && Objects.equals(this.tracedAttributes, other.tracedAttributes());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.verbose, this.streaming, this.operationNameConstructor, this.tracedAttributes);
            }
        }
    }
}

