/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.ServerCalls;
import io.helidon.grpc.core.WeightedBag;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.grpc.BindableServiceImpl;
import io.helidon.webserver.grpc.GrpcRoute;
import io.helidon.webserver.grpc.GrpcRouteHandler;
import io.helidon.webserver.grpc.GrpcService;
import io.helidon.webserver.grpc.GrpcServiceDescriptor;
import java.util.LinkedList;
import java.util.List;

class GrpcServiceRoute
extends GrpcRoute {
    private static final Descriptors.FileDescriptor EMPTY_PROTO;
    private final String serviceName;
    private final List<GrpcRouteHandler<?, ?>> routes;
    private final Descriptors.FileDescriptor proto;

    private GrpcServiceRoute(GrpcService service, List<GrpcRouteHandler<?, ?>> routes) {
        this.serviceName = service.serviceName();
        this.routes = routes;
        this.proto = service.proto();
    }

    private GrpcServiceRoute(String serviceName, List<GrpcRouteHandler<?, ?>> routes) {
        this(serviceName, routes, null);
    }

    private GrpcServiceRoute(String serviceName, List<GrpcRouteHandler<?, ?>> routes, Descriptors.FileDescriptor proto) {
        this.serviceName = serviceName;
        this.routes = routes;
        this.proto = proto == null ? EMPTY_PROTO : proto;
    }

    @Override
    String serviceName() {
        return this.serviceName;
    }

    @Override
    public Descriptors.FileDescriptor proto() {
        return this.proto;
    }

    static GrpcRoute create(GrpcService service, WeightedBag<ServerInterceptor> interceptors) {
        Routing svcRouter = new Routing(service, interceptors);
        service.update(svcRouter);
        return svcRouter.build();
    }

    static GrpcRoute create(BindableService service, WeightedBag<ServerInterceptor> interceptors) {
        ServerServiceDefinition definition = service.bindService();
        String serviceName = definition.getServiceDescriptor().getName();
        List<GrpcRouteHandler<?, ?>> routes = GrpcServiceRoute.buildRoutes(service, interceptors);
        return new GrpcServiceRoute(serviceName, routes);
    }

    static GrpcRoute create(GrpcServiceDescriptor service, WeightedBag<ServerInterceptor> interceptors) {
        BindableServiceImpl bindableService = BindableServiceImpl.create(service);
        ServerServiceDefinition definition = bindableService.bindService();
        String serviceName = definition.getServiceDescriptor().getName();
        List<GrpcRouteHandler<?, ?>> routes = GrpcServiceRoute.buildRoutes(bindableService, interceptors);
        return new GrpcServiceRoute(serviceName, routes, service.proto());
    }

    @Override
    GrpcRouteHandler<?, ?> handler(HttpPrologue prologue) {
        for (GrpcRouteHandler<?, ?> route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route;
        }
        throw new IllegalStateException("GrpcServiceRoute(" + this.serviceName + ") accepted prologue, but cannot provide route: " + String.valueOf(prologue));
    }

    @Override
    PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        for (GrpcRouteHandler<?, ?> route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return accepts;
        }
        return PathMatchers.MatchResult.notAccepted();
    }

    static List<GrpcRouteHandler<?, ?>> buildRoutes(BindableService service, WeightedBag<ServerInterceptor> interceptors) {
        LinkedList routes = new LinkedList();
        service.bindService().getMethods().forEach(method -> routes.add(GrpcRouteHandler.bindableMethod(service, method, interceptors)));
        return routes;
    }

    static {
        try {
            EMPTY_PROTO = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)DescriptorProtos.FileDescriptorProto.getDefaultInstance(), (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new Error("Unable to create an empty proto file descriptor", e);
        }
    }

    static class Routing
    implements GrpcService.Routing {
        private final List<GrpcRouteHandler<?, ?>> routes = new LinkedList();
        private final GrpcService service;
        private final WeightedBag<ServerInterceptor> interceptors;

        Routing(GrpcService service, WeightedBag<ServerInterceptor> interceptors) {
            this.service = service;
            this.interceptors = interceptors;
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing unary(String methodName, ServerCalls.UnaryMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.unary(this.service.proto(), this.service.serviceName(), methodName, method, this.interceptors));
            return this;
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing bidi(String methodName, ServerCalls.BidiStreamingMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.bidi(this.service.proto(), this.service.serviceName(), methodName, method, this.interceptors));
            return this;
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing serverStream(String methodName, ServerCalls.ServerStreamingMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.serverStream(this.service.proto(), this.service.serviceName(), methodName, method, this.interceptors));
            return this;
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing clientStream(String methodName, ServerCalls.ClientStreamingMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.clientStream(this.service.proto(), this.service.serviceName(), methodName, method, this.interceptors));
            return this;
        }

        public GrpcServiceRoute build() {
            return new GrpcServiceRoute(this.service, List.copyOf(this.routes));
        }
    }
}

