/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.stub.ServerCalls;
import io.helidon.grpc.core.GrpcHelper;
import io.helidon.grpc.core.MarshallerSupplier;
import io.helidon.grpc.core.WeightedBag;
import io.helidon.webserver.grpc.GrpcMethodDescriptor;
import io.helidon.webserver.grpc.GrpcService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class GrpcServiceDescriptor {
    public static final Context.Key<GrpcServiceDescriptor> SERVICE_DESCRIPTOR_KEY = Context.key((String)"Helidon.ServiceDescriptor");
    private final String name;
    private final String fullName;
    private final String packageName;
    private final Map<String, GrpcMethodDescriptor<?, ?>> methods;
    private final WeightedBag<ServerInterceptor> interceptors;
    private final Map<Context.Key<?>, Object> context;
    private final Descriptors.FileDescriptor proto;

    private GrpcServiceDescriptor(String name, Map<String, GrpcMethodDescriptor<?, ?>> methods, WeightedBag<ServerInterceptor> interceptors, Map<Context.Key<?>, Object> context, Descriptors.FileDescriptor proto) {
        String assignedName = Objects.requireNonNull(name);
        this.methods = methods;
        this.context = Collections.unmodifiableMap(context);
        this.interceptors = interceptors.copyMe();
        this.proto = proto;
        this.packageName = proto == null ? "" : proto.getPackage();
        String servicePrefix = this.packageName + (!this.packageName.isEmpty() ? "." : "");
        if (!servicePrefix.isEmpty() && assignedName.startsWith(servicePrefix)) {
            this.name = assignedName.replace(servicePrefix, "");
            this.fullName = assignedName;
        } else {
            this.name = assignedName;
            this.fullName = servicePrefix + assignedName;
        }
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return this.fullName;
    }

    public String packageName() {
        return this.packageName;
    }

    public GrpcMethodDescriptor<?, ?> method(String name) {
        return this.methods.get(name);
    }

    public Collection<GrpcMethodDescriptor<?, ?>> methods() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    public WeightedBag<ServerInterceptor> interceptors() {
        return this.interceptors.readOnly();
    }

    public Map<Context.Key<?>, Object> context() {
        return this.context;
    }

    public Descriptors.FileDescriptor proto() {
        return this.proto;
    }

    public String toString() {
        return "ServiceDescriptor(name='" + this.fullName + "')";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcServiceDescriptor that = (GrpcServiceDescriptor)o;
        return this.fullName.equals(that.fullName);
    }

    public int hashCode() {
        return Objects.hash(this.fullName);
    }

    public static Builder builder(Class<?> serviceClass, String name) {
        return new Builder(serviceClass, name);
    }

    public static Builder builder(GrpcService service) {
        return new Builder(service);
    }

    public static Builder builder(BindableService service) {
        return new Builder(service);
    }

    public static final class Builder
    implements Rules,
    io.helidon.common.Builder<Builder, GrpcServiceDescriptor> {
        private final Class<?> serviceClass;
        private String name;
        private Descriptors.FileDescriptor proto;
        private MarshallerSupplier marshallerSupplier = MarshallerSupplier.create();
        private final Map<String, GrpcMethodDescriptor.Builder<?, ?>> methodBuilders = new LinkedHashMap();
        private final WeightedBag<ServerInterceptor> interceptors = WeightedBag.create((double)1000.0);
        private final Map<Context.Key<?>, Object> context = new HashMap();

        Builder(Class<?> serviceClass, String name) {
            this.name = name == null || name.trim().isEmpty() ? serviceClass.getSimpleName() : name.trim();
            this.serviceClass = serviceClass;
        }

        Builder(GrpcService service) {
            this.name = service.serviceName();
            this.serviceClass = service.getClass();
        }

        Builder(BindableService service) {
            ServerServiceDefinition def = service.bindService();
            this.name = def.getServiceDescriptor().getName();
            this.serviceClass = service.getClass();
            Object schemaDescriptor = def.getServiceDescriptor().getSchemaDescriptor();
            if (schemaDescriptor instanceof ProtoFileDescriptorSupplier) {
                this.proto = ((ProtoFileDescriptorSupplier)schemaDescriptor).getFileDescriptor();
            }
            for (ServerMethodDefinition smd : def.getMethods()) {
                MethodDescriptor md = smd.getMethodDescriptor();
                ServerCallHandler handler = smd.getServerCallHandler();
                String methodName = GrpcHelper.extractMethodName((String)md.getFullMethodName());
                GrpcMethodDescriptor.Rules descriptor = GrpcMethodDescriptor.builder(this.name, methodName, md.toBuilder(), handler).marshallerSupplier(this.marshallerSupplier);
                this.methodBuilders.put(methodName, (GrpcMethodDescriptor.Builder<?, ?>)descriptor);
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("name cannot be null");
            }
            if (name.trim().isEmpty()) {
                throw new IllegalArgumentException("name cannot be blank");
            }
            this.name = name.trim();
            for (Map.Entry<String, GrpcMethodDescriptor.Builder<?, ?>> entry : this.methodBuilders.entrySet()) {
                entry.getValue().fullname(name + "/" + entry.getKey());
            }
            return this;
        }

        @Override
        public Builder proto(Descriptors.FileDescriptor proto) {
            this.proto = proto;
            return this;
        }

        @Override
        public Builder marshallerSupplier(MarshallerSupplier marshallerSupplier) {
            this.marshallerSupplier = marshallerSupplier;
            return this;
        }

        @Override
        public <ReqT, ResT> Builder unary(String name, ServerCalls.UnaryMethod<ReqT, ResT> method) {
            return this.unary(name, (ServerCalls.UnaryMethod)method, (GrpcMethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder unary(String name, ServerCalls.UnaryMethod<ReqT, ResT> method, GrpcMethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.UNARY, ServerCalls.asyncUnaryCall(method), configurer));
            return this;
        }

        @Override
        public <ReqT, ResT> Builder serverStreaming(String name, ServerCalls.ServerStreamingMethod<ReqT, ResT> method) {
            return this.serverStreaming(name, (ServerCalls.ServerStreamingMethod)method, (GrpcMethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder serverStreaming(String name, ServerCalls.ServerStreamingMethod<ReqT, ResT> method, GrpcMethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.SERVER_STREAMING, ServerCalls.asyncServerStreamingCall(method), configurer));
            return this;
        }

        @Override
        public <ReqT, ResT> Builder clientStreaming(String name, ServerCalls.ClientStreamingMethod<ReqT, ResT> method) {
            return this.clientStreaming(name, (ServerCalls.ClientStreamingMethod)method, (GrpcMethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder clientStreaming(String name, ServerCalls.ClientStreamingMethod<ReqT, ResT> method, GrpcMethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.CLIENT_STREAMING, ServerCalls.asyncClientStreamingCall(method), configurer));
            return this;
        }

        @Override
        public <ReqT, ResT> Builder bidirectional(String name, ServerCalls.BidiStreamingMethod<ReqT, ResT> method) {
            return this.bidirectional(name, (ServerCalls.BidiStreamingMethod)method, (GrpcMethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder bidirectional(String name, ServerCalls.BidiStreamingMethod<ReqT, ResT> method, GrpcMethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.BIDI_STREAMING, ServerCalls.asyncBidiStreamingCall(method), configurer));
            return this;
        }

        @Override
        public Builder intercept(ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors));
            return this;
        }

        @Override
        public Builder intercept(int priority, ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors), (double)priority);
            return this;
        }

        @Override
        public Builder intercept(String methodName, ServerInterceptor ... interceptors) {
            GrpcMethodDescriptor.Builder<?, ?> method = this.methodBuilders.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("No method exists with name '" + methodName + "'");
            }
            method.intercept(interceptors);
            return this;
        }

        @Override
        public Builder intercept(String methodName, int priority, ServerInterceptor ... interceptors) {
            GrpcMethodDescriptor.Builder<?, ?> method = this.methodBuilders.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("No method exists with name '" + methodName + "'");
            }
            method.intercept(priority, interceptors);
            return this;
        }

        @Override
        public <V> Builder addContextValue(Context.Key<V> key, V value) {
            this.context.put(key, value);
            return this;
        }

        public GrpcServiceDescriptor build() {
            LinkedHashMap methods = new LinkedHashMap();
            String fullName = this.getFullName();
            for (Map.Entry<String, GrpcMethodDescriptor.Builder<?, ?>> entry : this.methodBuilders.entrySet()) {
                String methodName = entry.getKey();
                String fullMethodName = MethodDescriptor.generateFullMethodName((String)fullName, (String)methodName);
                methods.put(methodName, (GrpcMethodDescriptor<?, ?>)entry.getValue().fullname(fullMethodName).build());
            }
            return new GrpcServiceDescriptor(this.name, methods, this.interceptors, this.context, this.proto);
        }

        public String toString() {
            return "ServiceDescriptor.Builder(name='" + this.name + "')";
        }

        private <ReqT, ResT> GrpcMethodDescriptor.Builder<ReqT, ResT> createMethodDescriptor(String methodName, MethodDescriptor.MethodType methodType, ServerCallHandler<ReqT, ResT> callHandler, GrpcMethodDescriptor.Configurer<ReqT, ResT> configurer) {
            MethodDescriptor.Builder grpcDesc = MethodDescriptor.newBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)this.getFullName(), (String)methodName)).setType(methodType).setSampledToLocalTracing(true);
            Class requestType = this.getTypeFromMethodDescriptor(methodName, true);
            Class responseType = this.getTypeFromMethodDescriptor(methodName, false);
            GrpcMethodDescriptor.Builder builder = ((GrpcMethodDescriptor.Builder)((GrpcMethodDescriptor.Builder)GrpcMethodDescriptor.builder(this.name, methodName, grpcDesc, callHandler).defaultMarshallerSupplier(this.marshallerSupplier).requestType(requestType)).responseType(responseType)).fullname(this.getFullName());
            if (configurer != null) {
                configurer.configure(builder);
            }
            return builder;
        }

        private <T> Class<T> getTypeFromMethodDescriptor(String methodName, boolean fInput) {
            if (this.proto == null) {
                return Object.class;
            }
            Descriptors.ServiceDescriptor svc = this.proto.findServiceByName(this.name);
            if (svc == null) {
                throw new IllegalArgumentException("Unable to find service " + this.name);
            }
            Descriptors.MethodDescriptor mtd = svc.findMethodByName(methodName);
            if (mtd == null) {
                throw new IllegalArgumentException("Unable to find method " + methodName + " in service " + this.name);
            }
            Descriptors.Descriptor type = fInput ? mtd.getInputType() : mtd.getOutputType();
            String pkg = this.getPackageName();
            String outerClass = this.getOuterClassName();
            String className = pkg + "." + outerClass + type.getName();
            try {
                return this.serviceClass.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private String getPackageName() {
            String pkg = this.proto.getOptions().getJavaPackage();
            return "".equals(pkg) ? this.proto.getPackage() : pkg;
        }

        private String getFullName() {
            String pkg = this.proto == null ? "" : this.proto.getPackage();
            Object serviceName = this.name;
            if (!pkg.isEmpty() && !((String)serviceName).startsWith(pkg + ".")) {
                serviceName = pkg + "." + (String)serviceName;
            }
            return serviceName;
        }

        private String getOuterClassName() {
            DescriptorProtos.FileOptions options = this.proto.getOptions();
            if (options.getJavaMultipleFiles()) {
                return "";
            }
            String outerClass = options.getJavaOuterClassname();
            if ("".equals(outerClass)) {
                outerClass = this.getOuterClassFromFileName(this.proto.getName());
            }
            return outerClass + "$";
        }

        private String getOuterClassFromFileName(String name) {
            name = name.substring(0, name.lastIndexOf(".proto"));
            String[] words = name.split("_");
            StringBuilder sb = new StringBuilder(name.length());
            for (String word : words) {
                sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
            }
            return sb.toString();
        }
    }

    @Deprecated(since="4.3.0", forRemoval=true)
    public static interface Aware {
        public void setServiceDescriptor(GrpcServiceDescriptor var1);
    }

    @FunctionalInterface
    public static interface Configurer {
        public void configure(Rules var1);
    }

    public static interface Rules {
        public Rules name(String var1);

        public String name();

        public Rules proto(Descriptors.FileDescriptor var1);

        public Rules marshallerSupplier(MarshallerSupplier var1);

        public Rules intercept(ServerInterceptor ... var1);

        public Rules intercept(int var1, ServerInterceptor ... var2);

        public Rules intercept(String var1, ServerInterceptor ... var2);

        public Rules intercept(String var1, int var2, ServerInterceptor ... var3);

        public <V> Rules addContextValue(Context.Key<V> var1, V var2);

        public <ReqT, ResT> Rules unary(String var1, ServerCalls.UnaryMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules unary(String var1, ServerCalls.UnaryMethod<ReqT, ResT> var2, GrpcMethodDescriptor.Configurer<ReqT, ResT> var3);

        public <ReqT, ResT> Rules serverStreaming(String var1, ServerCalls.ServerStreamingMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules serverStreaming(String var1, ServerCalls.ServerStreamingMethod<ReqT, ResT> var2, GrpcMethodDescriptor.Configurer<ReqT, ResT> var3);

        public <ReqT, ResT> Rules clientStreaming(String var1, ServerCalls.ClientStreamingMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules clientStreaming(String var1, ServerCalls.ClientStreamingMethod<ReqT, ResT> var2, GrpcMethodDescriptor.Configurer<ReqT, ResT> var3);

        public <ReqT, ResT> Rules bidirectional(String var1, ServerCalls.BidiStreamingMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules bidirectional(String var1, ServerCalls.BidiStreamingMethod<ReqT, ResT> var2, GrpcMethodDescriptor.Configurer<ReqT, ResT> var3);
    }
}

