/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.ServerCalls;
import io.helidon.config.Config;
import io.helidon.grpc.core.WeightedBag;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import io.helidon.service.registry.Services;
import io.helidon.webserver.Routing;
import io.helidon.webserver.grpc.ContextSettingServerInterceptor;
import io.helidon.webserver.grpc.GrpcConfig;
import io.helidon.webserver.grpc.GrpcRoute;
import io.helidon.webserver.grpc.GrpcRouteHandler;
import io.helidon.webserver.grpc.GrpcService;
import io.helidon.webserver.grpc.GrpcServiceDescriptor;
import io.helidon.webserver.grpc.GrpcServiceRoute;
import io.helidon.webserver.grpc.spi.GrpcServerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GrpcRouting
implements Routing {
    private static final GrpcRouting EMPTY = GrpcRouting.builder().build();
    private final ArrayList<GrpcRoute> routes;
    private final WeightedBag<ServerInterceptor> interceptors;
    private final ArrayList<GrpcServiceDescriptor> services;

    private GrpcRouting(Builder builder) {
        this.routes = new ArrayList<GrpcRoute>(builder.routes);
        this.interceptors = builder.interceptors;
        this.services = new ArrayList<GrpcServiceDescriptor>(builder.services.values());
    }

    public Class<? extends Routing> routingType() {
        return GrpcRouting.class;
    }

    public static Builder builder() {
        return new Builder();
    }

    static GrpcRouting empty() {
        return EMPTY;
    }

    public void beforeStart() {
        for (GrpcRoute route : this.routes) {
            route.beforeStart();
        }
    }

    public void afterStop() {
        for (GrpcRoute route : this.routes) {
            route.afterStop();
        }
    }

    public WeightedBag<ServerInterceptor> interceptors() {
        return this.interceptors;
    }

    public List<GrpcServiceDescriptor> services() {
        return this.services;
    }

    GrpcRouteHandler<?, ?> findRoute(HttpPrologue prologue) {
        for (GrpcRoute route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route.handler(prologue);
        }
        return null;
    }

    List<GrpcRoute> routes() {
        return this.routes;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, GrpcRouting> {
        private final List<GrpcRoute> routes = new LinkedList<GrpcRoute>();
        private final WeightedBag<ServerInterceptor> interceptors = WeightedBag.create((double)1000.0);
        private final Map<String, GrpcServiceDescriptor> services = new LinkedHashMap<String, GrpcServiceDescriptor>();

        private Builder() {
            this.interceptors.add((Object)ContextSettingServerInterceptor.instance());
            Config config = (Config)Services.get(Config.class);
            GrpcConfig grpcConfig = GrpcConfig.create(config.get("grpc"));
            for (GrpcServerService serverService : grpcConfig.grpcServices()) {
                this.interceptors.merge(serverService.interceptors());
            }
        }

        public GrpcRouting build() {
            return new GrpcRouting(this);
        }

        public Builder service(GrpcService service) {
            this.routes.add(GrpcServiceRoute.create(service, this.interceptors));
            return this;
        }

        public Builder service(BindableService service) {
            this.routes.add(GrpcServiceRoute.create(service, this.interceptors));
            return this;
        }

        public Builder service(Descriptors.FileDescriptor proto, BindableService service) {
            for (ServerMethodDefinition method : service.bindService().getMethods()) {
                this.routes.add(GrpcRouteHandler.methodDefinition(method, proto, this.interceptors));
            }
            return this;
        }

        public Builder service(GrpcServiceDescriptor service) {
            WeightedBag<ServerInterceptor> routeInterceptors;
            String name = service.name();
            if (this.services.containsKey(name)) {
                throw new IllegalArgumentException("Attempted to register service name " + name + " multiple times");
            }
            this.services.put(name, service);
            WeightedBag<ServerInterceptor> serviceInterceptors = service.interceptors();
            if (!serviceInterceptors.isEmpty()) {
                routeInterceptors = WeightedBag.create();
                routeInterceptors.merge(serviceInterceptors);
                routeInterceptors.merge(this.interceptors);
            } else {
                routeInterceptors = this.interceptors;
            }
            this.routes.add(GrpcServiceRoute.create(service, routeInterceptors));
            return this;
        }

        public Builder service(ServerServiceDefinition service) {
            for (ServerMethodDefinition method : service.getMethods()) {
                this.routes.add(GrpcRouteHandler.methodDefinition(method, null, this.interceptors));
            }
            return this;
        }

        public Builder intercept(ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors));
            return this;
        }

        public Builder intercept(int weight, ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors), (double)weight);
            return this;
        }

        public <ReqT, ResT> Builder unary(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.UnaryMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.unary(proto, serviceName, methodName, method, this.interceptors));
            return this;
        }

        public <ReqT, ResT> Builder bidi(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.BidiStreamingMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.bidi(proto, serviceName, methodName, method, this.interceptors));
            return this;
        }

        public <ReqT, ResT> Builder serverStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ServerStreamingMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.serverStream(proto, serviceName, methodName, method, this.interceptors));
            return this;
        }

        public <ReqT, ResT> Builder clientStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ClientStreamingMethod<ReqT, ResT> method) {
            this.routes.add(GrpcRouteHandler.clientStream(proto, serviceName, methodName, method, this.interceptors));
            return this;
        }
    }
}

