/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.ServerCalls;
import io.helidon.grpc.core.WeightedBag;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.grpc.BindableServiceImpl;
import io.helidon.webserver.grpc.GrpcInterceptorUtil;
import io.helidon.webserver.grpc.GrpcRoute;
import io.helidon.webserver.grpc.GrpcServiceDescriptor;
import io.helidon.webserver.grpc.ProtoMarshaller;

class GrpcRouteHandler<ReqT, ResT>
extends GrpcRoute {
    private final MethodDescriptor<ReqT, ResT> method;
    private final PathMatcher pathMatcher;
    private final ServerCallHandler<ReqT, ResT> callHandler;
    private final Descriptors.FileDescriptor proto;

    private GrpcRouteHandler(MethodDescriptor<ReqT, ResT> method, PathMatcher pathMatcher, ServerCallHandler<ReqT, ResT> callHandler, Descriptors.FileDescriptor proto) {
        this.method = method;
        this.pathMatcher = pathMatcher;
        this.callHandler = callHandler;
        this.proto = proto;
    }

    @Override
    String serviceName() {
        return this.method.getServiceName();
    }

    @Override
    public Descriptors.FileDescriptor proto() {
        return this.proto;
    }

    static <ReqT, ResT> GrpcRouteHandler<ReqT, ResT> unary(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.UnaryMethod<ReqT, ResT> method, WeightedBag<ServerInterceptor> interceptors) {
        ServerCallHandler callHandler = GrpcInterceptorUtil.interceptHandler(ServerCalls.asyncUnaryCall(method), interceptors);
        return GrpcRouteHandler.grpc(proto, serviceName, methodName, callHandler);
    }

    static <ReqT, ResT> GrpcRouteHandler<ReqT, ResT> bidi(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.BidiStreamingMethod<ReqT, ResT> method, WeightedBag<ServerInterceptor> interceptors) {
        ServerCallHandler callHandler = GrpcInterceptorUtil.interceptHandler(ServerCalls.asyncBidiStreamingCall(method), interceptors);
        return GrpcRouteHandler.grpc(proto, serviceName, methodName, callHandler);
    }

    static <ReqT, ResT> GrpcRouteHandler<ReqT, ResT> serverStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ServerStreamingMethod<ReqT, ResT> method, WeightedBag<ServerInterceptor> interceptors) {
        ServerCallHandler callHandler = GrpcInterceptorUtil.interceptHandler(ServerCalls.asyncServerStreamingCall(method), interceptors);
        return GrpcRouteHandler.grpc(proto, serviceName, methodName, callHandler);
    }

    static <ReqT, ResT> GrpcRouteHandler<ReqT, ResT> clientStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ClientStreamingMethod<ReqT, ResT> method, WeightedBag<ServerInterceptor> interceptors) {
        ServerCallHandler callHandler = GrpcInterceptorUtil.interceptHandler(ServerCalls.asyncClientStreamingCall(method), interceptors);
        return GrpcRouteHandler.grpc(proto, serviceName, methodName, callHandler);
    }

    static <ReqT, ResT> GrpcRouteHandler<ReqT, ResT> methodDefinition(ServerMethodDefinition<ReqT, ResT> definition, Descriptors.FileDescriptor proto, WeightedBag<ServerInterceptor> interceptors) {
        ServerCallHandler callHandler = GrpcInterceptorUtil.interceptHandler(definition.getServerCallHandler(), interceptors);
        return GrpcRouteHandler.grpc(definition.getMethodDescriptor(), callHandler, proto);
    }

    public static <ReqT, ResT> GrpcRouteHandler<ReqT, ResT> bindableMethod(BindableService service, ServerMethodDefinition<?, ?> method, WeightedBag<ServerInterceptor> interceptors) {
        GrpcServiceDescriptor grpcServiceDescriptor;
        ServerServiceDefinition definition = service.bindService();
        String path = definition.getServiceDescriptor().getName() + "/" + method.getMethodDescriptor().getBareMethodName();
        ServerCallHandler serverCallHandler = method.getServerCallHandler();
        if (service instanceof BindableServiceImpl) {
            BindableServiceImpl svc = (BindableServiceImpl)service;
            grpcServiceDescriptor = svc.serviceDescriptor();
        } else {
            grpcServiceDescriptor = null;
        }
        ServerCallHandler callHandler = GrpcInterceptorUtil.interceptHandler(serverCallHandler, interceptors, grpcServiceDescriptor);
        return new GrpcRouteHandler(method.getMethodDescriptor(), PathMatchers.exact((String)path), callHandler, null);
    }

    @Override
    GrpcRouteHandler<?, ?> handler(HttpPrologue grpcPrologue) {
        return this;
    }

    @Override
    PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        return this.pathMatcher.match(prologue.uriPath());
    }

    MethodDescriptor<ReqT, ResT> method() {
        return this.method;
    }

    ServerCallHandler<ReqT, ResT> callHandler() {
        return this.callHandler;
    }

    private static <ResT, ReqT> GrpcRouteHandler<ReqT, ResT> grpc(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCallHandler<ReqT, ResT> callHandler) {
        String simpleName = GrpcRouteHandler.getSimpleName(serviceName);
        Descriptors.ServiceDescriptor svc = proto.findServiceByName(simpleName);
        if (svc == null) {
            throw new IllegalArgumentException("Unable to find gRPC service '" + simpleName + "'");
        }
        Descriptors.MethodDescriptor mtd = svc.findMethodByName(methodName);
        if (mtd == null) {
            throw new IllegalArgumentException("Unable to find gRPC method '" + methodName + "' in service '" + simpleName + "'");
        }
        String path = svc.getFullName() + "/" + methodName;
        Class requestType = GrpcRouteHandler.load(GrpcRouteHandler.getClassName(mtd.getInputType()));
        Class responseType = GrpcRouteHandler.load(GrpcRouteHandler.getClassName(mtd.getOutputType()));
        MethodDescriptor.Marshaller reqMarshaller = ProtoMarshaller.get(requestType);
        MethodDescriptor.Marshaller resMarshaller = ProtoMarshaller.get(responseType);
        MethodDescriptor.Builder grpcDesc = MethodDescriptor.newBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)simpleName, (String)methodName)).setType(GrpcRouteHandler.getMethodType(mtd)).setFullMethodName(path).setRequestMarshaller(reqMarshaller).setResponseMarshaller(resMarshaller).setSampledToLocalTracing(true);
        return new GrpcRouteHandler<ReqT, ResT>(grpcDesc.build(), PathMatchers.exact((String)path), callHandler, proto);
    }

    private static <ResT, ReqT> GrpcRouteHandler<ReqT, ResT> grpc(MethodDescriptor<ReqT, ResT> grpcDesc, ServerCallHandler<ReqT, ResT> callHandler, Descriptors.FileDescriptor proto) {
        return new GrpcRouteHandler<ReqT, ResT>(grpcDesc, PathMatchers.exact((String)grpcDesc.getFullMethodName()), callHandler, proto);
    }

    private static String getClassName(Descriptors.Descriptor descriptor) {
        Descriptors.FileDescriptor fd = descriptor.getFile();
        String outerClass = GrpcRouteHandler.getOuterClass(fd);
        String pkg = fd.getOptions().getJavaPackage();
        pkg = "".equals(pkg) ? fd.getPackage() : pkg;
        return pkg + "." + outerClass + descriptor.getName().replace('.', '$');
    }

    private static <T> Class<T> load(String className) {
        try {
            return GrpcRouteHandler.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to load class \"" + className + "\" for grpc", e);
        }
    }

    private static String getOuterClass(Descriptors.FileDescriptor proto) {
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options.getJavaMultipleFiles()) {
            return "";
        }
        String outerClass = options.getJavaOuterClassname();
        if ("".equals(outerClass)) {
            outerClass = GrpcRouteHandler.getOuterClassFromFileName(proto.getName());
        }
        return outerClass + "$";
    }

    private static String getOuterClassFromFileName(String name) {
        name = name.substring(0, name.lastIndexOf(".proto"));
        String[] words = name.split("_");
        StringBuilder sb = new StringBuilder(name.length());
        for (String word : words) {
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return sb.toString();
    }

    private static MethodDescriptor.MethodType getMethodType(Descriptors.MethodDescriptor mtd) {
        if (mtd.isClientStreaming()) {
            if (mtd.isServerStreaming()) {
                return MethodDescriptor.MethodType.BIDI_STREAMING;
            }
            return MethodDescriptor.MethodType.CLIENT_STREAMING;
        }
        if (mtd.isServerStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        return MethodDescriptor.MethodType.UNARY;
    }

    private static String getSimpleName(String fullName) {
        int k = fullName.lastIndexOf(46);
        return k < 0 ? fullName : fullName.substring(k + 1);
    }
}

