/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.Status;
import io.grpc.reflection.v1alpha.ErrorResponse;
import io.grpc.reflection.v1alpha.FileDescriptorResponse;
import io.grpc.reflection.v1alpha.ListServiceResponse;
import io.grpc.reflection.v1alpha.ServerReflectionProto;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.reflection.v1alpha.ServiceResponse;
import io.grpc.stub.StreamObserver;
import io.helidon.webserver.grpc.GrpcReflectionFeature;
import io.helidon.webserver.grpc.GrpcRoute;
import io.helidon.webserver.grpc.GrpcRouting;
import io.helidon.webserver.grpc.GrpcService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class GrpcReflectionServiceV1Alpha
implements GrpcService {
    private static final Map<String, ByteString> FILE_DESCRIPTOR_CACHE = new ConcurrentHashMap<String, ByteString>();
    private final String socket;

    GrpcReflectionServiceV1Alpha(String socket) {
        this.socket = socket;
    }

    @Override
    public Descriptors.FileDescriptor proto() {
        return ServerReflectionProto.getDescriptor();
    }

    @Override
    public String serviceName() {
        List services = this.proto().getServices();
        return ((Descriptors.ServiceDescriptor)services.getFirst()).getFullName();
    }

    @Override
    public void update(GrpcService.Routing router) {
        router.bidi("ServerReflectionInfo", this::serverReflectionInfo);
    }

    private StreamObserver<ServerReflectionRequest> serverReflectionInfo(final StreamObserver<ServerReflectionResponse> res) {
        return new StreamObserver<ServerReflectionRequest>(){

            public void onNext(ServerReflectionRequest req) {
                res.onNext((Object)GrpcReflectionServiceV1Alpha.this.processRequest(req));
            }

            public void onError(Throwable t) {
                res.onError(t);
            }

            public void onCompleted() {
                res.onCompleted();
            }
        };
    }

    private ServerReflectionResponse processRequest(ServerReflectionRequest req) {
        return switch (req.getMessageRequestCase().getNumber()) {
            case 7 -> this.listServices();
            case 3 -> this.findFile(req);
            case 4 -> this.findSymbol(req);
            case 5 -> this.findExtensionField(req);
            default -> this.notImplemented();
        };
    }

    private ServerReflectionResponse listServices() {
        List<GrpcRouting> grpcRoutings = GrpcReflectionFeature.socketGrpcRoutings().get(this.socket);
        ListServiceResponse.Builder builder = ListServiceResponse.newBuilder();
        for (GrpcRouting grpcRouting : grpcRoutings) {
            for (GrpcRoute grpcRoute : grpcRouting.routes()) {
                builder.addService(ServiceResponse.newBuilder().setName(grpcRoute.serviceName()).build());
            }
        }
        return ServerReflectionResponse.newBuilder().setListServicesResponse(builder).build();
    }

    private ServerReflectionResponse findFile(ServerReflectionRequest req) {
        String fileName = req.getFileByFilename();
        String cachedFileNameKey = "/" + fileName;
        ByteString byteString = FILE_DESCRIPTOR_CACHE.get(cachedFileNameKey);
        if (byteString != null) {
            return this.fileDescResponse(byteString);
        }
        List<GrpcRouting> grpcRoutings = GrpcReflectionFeature.socketGrpcRoutings().get(this.socket);
        for (GrpcRouting grpcRouting : grpcRoutings) {
            for (GrpcRoute grpcRoute : grpcRouting.routes()) {
                Descriptors.FileDescriptor fileDesc = grpcRoute.proto();
                if (!fileDesc.getFile().getFullName().equals(fileName)) continue;
                return this.symbolFound(fileDesc, cachedFileNameKey);
            }
        }
        return this.notFound("Unable to find file name " + fileName);
    }

    private ServerReflectionResponse findSymbol(ServerReflectionRequest req) {
        String symbol = req.getFileContainingSymbol();
        ByteString byteString = FILE_DESCRIPTOR_CACHE.get(symbol);
        if (byteString != null) {
            return this.fileDescResponse(byteString);
        }
        List<GrpcRouting> grpcRoutings = GrpcReflectionFeature.socketGrpcRoutings().get(this.socket);
        for (GrpcRouting grpcRouting : grpcRoutings) {
            for (GrpcRoute grpcRoute : grpcRouting.routes()) {
                Descriptors.FileDescriptor fileDesc = grpcRoute.proto();
                List services = fileDesc.getServices();
                for (Descriptors.ServiceDescriptor service : services) {
                    if (service.getFullName().equals(symbol)) {
                        return this.symbolFound(fileDesc, symbol);
                    }
                    List methods = service.getMethods();
                    for (Descriptors.MethodDescriptor method : methods) {
                        if (!method.getFullName().equals(symbol)) continue;
                        return this.symbolFound(fileDesc, symbol);
                    }
                }
                List types = fileDesc.getMessageTypes();
                for (Descriptors.Descriptor type : types) {
                    if (!type.getFullName().equals(symbol)) continue;
                    return this.symbolFound(fileDesc, symbol);
                }
            }
        }
        return this.notFound("Unable to find proto file for " + symbol);
    }

    private ServerReflectionResponse findExtensionField(ServerReflectionRequest req) {
        String type = req.getFileContainingExtension().getContainingType();
        int number = req.getFileContainingExtension().getExtensionNumber();
        String cachedFileNameKey = number + type;
        ByteString byteString = FILE_DESCRIPTOR_CACHE.get(cachedFileNameKey);
        if (byteString != null) {
            return this.fileDescResponse(byteString);
        }
        List<GrpcRouting> grpcRoutings = GrpcReflectionFeature.socketGrpcRoutings().get(this.socket);
        for (GrpcRouting grpcRouting : grpcRoutings) {
            for (GrpcRoute grpcRoute : grpcRouting.routes()) {
                Descriptors.FileDescriptor fileDesc = grpcRoute.proto();
                List extensions = fileDesc.getExtensions();
                for (Descriptors.FieldDescriptor extension : extensions) {
                    if (!extension.getContainingType().getFullName().equals(type) || extension.toProto().getNumber() != number) continue;
                    return this.symbolFound(fileDesc, cachedFileNameKey);
                }
            }
        }
        return this.notFound("Unable to find proto file for " + type);
    }

    private ServerReflectionResponse symbolFound(Descriptors.FileDescriptor fileDesc, String symbol) {
        ByteString byteString;
        DescriptorProtos.FileDescriptorProto proto = fileDesc.toProto();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            proto.writeTo((OutputStream)baos);
            byteString = ByteString.copyFrom((byte[])baos.toByteArray());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ByteString cachedValue = FILE_DESCRIPTOR_CACHE.putIfAbsent(symbol, byteString);
        return this.fileDescResponse(cachedValue != null ? cachedValue : byteString);
    }

    private ServerReflectionResponse fileDescResponse(ByteString byteString) {
        FileDescriptorResponse.Builder builder = FileDescriptorResponse.newBuilder();
        builder.addFileDescriptorProto(byteString);
        return ServerReflectionResponse.newBuilder().setFileDescriptorResponse(builder.build()).build();
    }

    private ServerReflectionResponse notImplemented() {
        return ServerReflectionResponse.newBuilder().setErrorResponse(ErrorResponse.newBuilder().setErrorCode(Status.UNIMPLEMENTED.getCode().value()).setErrorMessage("Reflection request not implemented").build()).build();
    }

    private ServerReflectionResponse notFound(String message) {
        return ServerReflectionResponse.newBuilder().setErrorResponse(ErrorResponse.newBuilder().setErrorCode(Status.NOT_FOUND.getCode().value()).setErrorMessage(message).build()).build();
    }
}

