/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.common.config.Config;
import io.helidon.webserver.Routing;
import io.helidon.webserver.grpc.GrpcReflectionConfig;
import io.helidon.webserver.grpc.GrpcReflectionService;
import io.helidon.webserver.grpc.GrpcReflectionServiceV1Alpha;
import io.helidon.webserver.grpc.GrpcRouting;
import io.helidon.webserver.spi.ServerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=GrpcReflectionConfig.class)
public class GrpcReflectionFeature
implements Weighted,
ServerFeature,
RuntimeType.Api<GrpcReflectionConfig> {
    private static final System.Logger LOGGER = System.getLogger(GrpcReflectionFeature.class.getName());
    static final String GRPC_REFLECTION = "grpc-reflection";
    static final Map<String, List<GrpcRouting>> SOCKET_GRPC_ROUTINGS = new HashMap<String, List<GrpcRouting>>();
    private final GrpcReflectionConfig config;

    GrpcReflectionFeature(GrpcReflectionConfig config) {
        this.config = config;
    }

    public static GrpcReflectionConfig.Builder builder() {
        return GrpcReflectionConfig.builder();
    }

    public static GrpcReflectionFeature create(GrpcReflectionConfig config) {
        return new GrpcReflectionFeature(config);
    }

    public static GrpcReflectionFeature create(Consumer<GrpcReflectionConfig.Builder> builderConsumer) {
        return ((GrpcReflectionConfig.Builder)GrpcReflectionFeature.builder().update(builderConsumer)).build();
    }

    public static GrpcReflectionFeature create() {
        return GrpcReflectionFeature.builder().build();
    }

    public static GrpcReflectionFeature create(Config config) {
        return ((GrpcReflectionConfig.Builder)GrpcReflectionFeature.builder().config(config)).build();
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        if (!this.config.enabled()) {
            return;
        }
        HashSet<String> sockets = new HashSet<String>(this.config.sockets());
        if (sockets.isEmpty()) {
            sockets.addAll(featureContext.sockets());
            sockets.add("@default");
        }
        sockets.forEach(socket -> {
            ServerFeature.SocketBuilders sb = featureContext.socket(socket);
            if (sb.routingBuilders().hasRouting(GrpcRouting.Builder.class)) {
                ((GrpcRouting.Builder)sb.routingBuilders().routingBuilder(GrpcRouting.Builder.class)).service(new GrpcReflectionService((String)socket)).service(new GrpcReflectionServiceV1Alpha((String)socket));
            } else {
                LOGGER.log(System.Logger.Level.WARNING, "Unable to register gRPC reflection service, no gRPC routes found for socket " + socket);
            }
            sb.listener().routings().forEach(routingBuilder -> {
                Routing routing = (Routing)routingBuilder.build();
                if (routing instanceof GrpcRouting) {
                    GrpcRouting grpcRouting = (GrpcRouting)routing;
                    List grpcRoutings = SOCKET_GRPC_ROUTINGS.computeIfAbsent((String)socket, k -> new ArrayList());
                    grpcRoutings.add(grpcRouting);
                }
            });
        });
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return GRPC_REFLECTION;
    }

    public GrpcReflectionConfig prototype() {
        return this.config;
    }

    static Map<String, List<GrpcRouting>> socketGrpcRoutings() {
        return SOCKET_GRPC_ROUTINGS;
    }
}

