/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webserver.grpc.GrpcReflectionConfigBlueprint;
import io.helidon.webserver.grpc.GrpcReflectionFeature;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.grpc.GrpcReflectionConfigBlueprint")
public interface GrpcReflectionConfig
extends GrpcReflectionConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcReflectionConfig instance) {
        return (Builder)GrpcReflectionConfig.builder().from(instance);
    }

    public static GrpcReflectionConfig create(Config config) {
        return ((Builder)GrpcReflectionConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static GrpcReflectionConfig create(io.helidon.common.config.Config config) {
        return GrpcReflectionConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static GrpcReflectionConfig create() {
        return GrpcReflectionConfig.builder().buildPrototype();
    }

    @Override
    public Set<String> sockets();

    @Override
    public String name();

    @Override
    public boolean enabled();

    public static class Builder
    extends BuilderBase<Builder, GrpcReflectionConfig>
    implements io.helidon.common.Builder<Builder, GrpcReflectionFeature> {
        private Builder() {
        }

        public GrpcReflectionConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcReflectionConfigImpl(this);
        }

        public GrpcReflectionFeature build() {
            return GrpcReflectionFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcReflectionConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Set<String> sockets = new LinkedHashSet<String>();
        private boolean enabled = false;
        private Config config;
        private String name = "grpc-reflection";

        protected BuilderBase() {
        }

        public BUILDER from(GrpcReflectionConfig prototype) {
            this.addSockets(prototype.sockets());
            this.name(prototype.name());
            this.enabled(prototype.enabled());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addSockets(builder.sockets);
            this.name(builder.name());
            this.enabled(builder.enabled());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocket(String socket) {
            Objects.requireNonNull(socket);
            this.sockets.add(socket);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public String name() {
            return this.name;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcReflectionConfigBuilder{sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",enabled=" + this.enabled + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class GrpcReflectionConfigImpl
        implements GrpcReflectionConfig,
        Supplier<GrpcReflectionFeature> {
            private final boolean enabled;
            private final Set<String> sockets;
            private final String name;

            protected GrpcReflectionConfigImpl(BuilderBase<?, ?> builder) {
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
                this.name = builder.name();
                this.enabled = builder.enabled();
            }

            public GrpcReflectionFeature build() {
                return GrpcReflectionFeature.create(this);
            }

            @Override
            public GrpcReflectionFeature get() {
                return this.build();
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            public String toString() {
                return "GrpcReflectionConfig{sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",enabled=" + this.enabled + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcReflectionConfig)) {
                    return false;
                }
                GrpcReflectionConfig other = (GrpcReflectionConfig)o;
                return Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.name, other.name()) && this.enabled == other.enabled();
            }

            public int hashCode() {
                return Objects.hash(this.sockets, this.name, this.enabled);
            }
        }
    }
}

