/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.grpc.GrpcConfig;
import io.helidon.webserver.grpc.GrpcProtocolHandler;
import io.helidon.webserver.grpc.GrpcProtocolHandlerNotFound;
import io.helidon.webserver.grpc.GrpcRouteHandler;
import io.helidon.webserver.grpc.GrpcRouting;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.http2.spi.SubProtocolResult;

public class GrpcProtocolSelector
implements Http2SubProtocolSelector {
    private final GrpcConfig grpcConfig;

    private GrpcProtocolSelector(GrpcConfig grpcConfig) {
        this.grpcConfig = grpcConfig;
    }

    public static GrpcProtocolSelector create(GrpcConfig grpcConfig) {
        return new GrpcProtocolSelector(grpcConfig);
    }

    public SubProtocolResult subProtocol(ConnectionContext ctx, HttpPrologue prologue, Http2Headers headers, Http2StreamWriter streamWriter, int streamId, Http2Settings serverSettings, Http2Settings clientSettings, StreamFlowControl flowControl, Http2StreamState currentStreamState, Router router) {
        String contentType;
        if (prologue.method() != Method.POST) {
            return NOT_SUPPORTED;
        }
        Headers httpHeaders = headers.httpHeaders();
        if (httpHeaders.contains(HeaderNames.CONTENT_TYPE) && (contentType = (String)httpHeaders.get(HeaderNames.CONTENT_TYPE).get()).startsWith("application/grpc")) {
            GrpcRouting routing = (GrpcRouting)router.routing(GrpcRouting.class, (Routing)GrpcRouting.empty());
            GrpcRouteHandler<?, ?> route = routing.findRoute(prologue);
            if (route == null) {
                return new SubProtocolResult(true, (Http2SubProtocolSelector.SubProtocolHandler)new GrpcProtocolHandlerNotFound(streamWriter, streamId, currentStreamState));
            }
            return new SubProtocolResult(true, new GrpcProtocolHandler(headers, streamWriter, streamId, flowControl, currentStreamState, route, this.grpcConfig));
        }
        return NOT_SUPPORTED;
    }
}

