/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.helidon.grpc.core.MarshallerSupplier;
import io.helidon.grpc.core.WeightedBag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GrpcMethodDescriptor<ReqT, ResT> {
    private final String name;
    private final MethodDescriptor<ReqT, ResT> descriptor;
    private final ServerCallHandler<ReqT, ResT> callHandler;
    private final Map<Context.Key<?>, Object> context;
    private final WeightedBag<ServerInterceptor> interceptors;
    private final Class<ReqT> requestType;
    private final Class<ResT> responseType;

    private GrpcMethodDescriptor(String name, MethodDescriptor<ReqT, ResT> descriptor, Class<ReqT> requestType, Class<ResT> responseType, ServerCallHandler<ReqT, ResT> callHandler, Map<Context.Key<?>, Object> context, WeightedBag<ServerInterceptor> interceptors) {
        this.name = name;
        this.descriptor = descriptor;
        this.requestType = requestType;
        this.responseType = responseType;
        this.callHandler = callHandler;
        this.context = context;
        this.interceptors = interceptors.copyMe();
    }

    public String name() {
        return this.name;
    }

    public MethodDescriptor<ReqT, ResT> descriptor() {
        return this.descriptor;
    }

    public ServerCallHandler<ReqT, ResT> callHandler() {
        return this.callHandler;
    }

    public Class<ReqT> requestType() {
        return this.requestType;
    }

    public Class<ResT> responseType() {
        return this.responseType;
    }

    public Map<Context.Key<?>, Object> context() {
        return Collections.unmodifiableMap(this.context);
    }

    public WeightedBag<ServerInterceptor> interceptors() {
        return this.interceptors.readOnly();
    }

    static <ReqT, ResT> Builder<ReqT, ResT> builder(String serviceName, String name, MethodDescriptor.Builder<ReqT, ResT> descriptor, ServerCallHandler<ReqT, ResT> callHandler) {
        return new Builder<ReqT, ResT>(serviceName, name, descriptor, callHandler);
    }

    static <ReqT, ResT> GrpcMethodDescriptor<ReqT, ResT> create(String serviceName, String name, MethodDescriptor.Builder<ReqT, ResT> descriptor, ServerCallHandler<ReqT, ResT> callHandler) {
        return GrpcMethodDescriptor.builder(serviceName, name, descriptor, callHandler).build();
    }

    public String toString() {
        String fullName = this.descriptor == null ? null : this.descriptor.getFullMethodName();
        return "MethodDescriptor(name='" + this.name + "'fullName='" + fullName + "')";
    }

    static final class Builder<ReqT, ResT>
    implements Rules<ReqT, ResT>,
    io.helidon.common.Builder<Builder<ReqT, ResT>, GrpcMethodDescriptor<ReqT, ResT>> {
        private final String name;
        private final MethodDescriptor.Builder<ReqT, ResT> descriptor;
        private final ServerCallHandler<ReqT, ResT> callHandler;
        private final WeightedBag<ServerInterceptor> interceptors = WeightedBag.create((double)1000.0);
        private final Map<Context.Key<?>, Object> context = new HashMap();
        private Class<?> requestType;
        private Class<?> responseType;
        private MarshallerSupplier defaultMarshallerSupplier = MarshallerSupplier.create();
        private MarshallerSupplier marshallerSupplier;

        Builder(String serviceName, String name, MethodDescriptor.Builder<ReqT, ResT> descriptor, ServerCallHandler<ReqT, ResT> callHandler) {
            this.name = name;
            this.callHandler = callHandler;
            this.descriptor = descriptor.setFullMethodName(serviceName + "/" + name);
        }

        Builder<ReqT, ResT> fullname(String name) {
            this.descriptor.setFullMethodName(name);
            return this;
        }

        @Override
        public Builder<ReqT, ResT> marshallerSupplier(MarshallerSupplier supplier) {
            this.marshallerSupplier = supplier;
            return this;
        }

        Builder<ReqT, ResT> defaultMarshallerSupplier(MarshallerSupplier supplier) {
            this.defaultMarshallerSupplier = supplier == null ? MarshallerSupplier.create() : supplier;
            return this;
        }

        @Override
        public <T> Builder<ReqT, ResT> addContextValue(Context.Key<T> key, T value) {
            this.context.put(Objects.requireNonNull(key, "The context key cannot be null"), value);
            return this;
        }

        @Override
        public Builder<ReqT, ResT> intercept(ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors));
            this.processInterceptors(interceptors);
            return this;
        }

        @Override
        public Rules<ReqT, ResT> intercept(int priority, ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors), (double)priority);
            this.processInterceptors(interceptors);
            return this;
        }

        @Override
        public <Rnew> Builder<Rnew, ResT> requestType(Class<Rnew> requestType) {
            this.requestType = requestType;
            return this;
        }

        @Override
        public <Rnew> Builder<ReqT, Rnew> responseType(Class<Rnew> responseType) {
            this.responseType = responseType;
            return this;
        }

        public GrpcMethodDescriptor<ReqT, ResT> build() {
            MarshallerSupplier supplier = this.marshallerSupplier;
            if (supplier == null) {
                supplier = this.defaultMarshallerSupplier;
            }
            if (this.requestType != null) {
                this.descriptor.setRequestMarshaller(supplier.get(this.requestType));
            }
            if (this.responseType != null) {
                this.descriptor.setResponseMarshaller(supplier.get(this.responseType));
            }
            return new GrpcMethodDescriptor(this.name, this.descriptor.build(), this.requestType, this.requestType, this.callHandler, this.context, this.interceptors);
        }

        private void processInterceptors(ServerInterceptor ... interceptors) {
            Arrays.stream(interceptors).filter(interceptor -> Configurer.class.isAssignableFrom(interceptor.getClass())).map(Configurer.class::cast).forEach(interceptor -> interceptor.configure(this));
        }
    }

    @FunctionalInterface
    public static interface Configurer<ReqT, ResT> {
        public void configure(Rules<ReqT, ResT> var1);
    }

    public static interface Rules<ReqT, ResT> {
        public <T> Rules<ReqT, ResT> addContextValue(Context.Key<T> var1, T var2);

        public Rules<ReqT, ResT> intercept(ServerInterceptor ... var1);

        public Rules<ReqT, ResT> intercept(int var1, ServerInterceptor ... var2);

        public Rules<ReqT, ResT> marshallerSupplier(MarshallerSupplier var1);

        public <Rnew> Rules<Rnew, ResT> requestType(Class<Rnew> var1);

        public <Rnew> Rules<ReqT, Rnew> responseType(Class<Rnew> var1);
    }
}

