/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.grpc.core.WeightedBag;
import io.helidon.webserver.grpc.GrpcServiceDescriptor;

class GrpcInterceptorUtil {
    private GrpcInterceptorUtil() {
    }

    static <ReqT, RespT> ServerCallHandler<ReqT, RespT> interceptHandler(ServerCallHandler<ReqT, RespT> handler, WeightedBag<ServerInterceptor> interceptors) {
        return GrpcInterceptorUtil.interceptHandler(handler, interceptors, null);
    }

    static <ReqT, RespT> ServerCallHandler<ReqT, RespT> interceptHandler(ServerCallHandler<ReqT, RespT> handler, WeightedBag<ServerInterceptor> interceptors, GrpcServiceDescriptor serviceDescriptor) {
        for (ServerInterceptor interceptor : interceptors.stream().distinct().toList().reversed()) {
            handler = new InterceptingCallHandler<ReqT, RespT>(serviceDescriptor, interceptor, handler);
        }
        return handler;
    }

    static final class InterceptingCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private final GrpcServiceDescriptor serviceDescriptor;
        private final ServerInterceptor interceptor;
        private final ServerCallHandler<ReqT, RespT> callHandler;

        private InterceptingCallHandler(GrpcServiceDescriptor serviceDescriptor, ServerInterceptor interceptor, ServerCallHandler<ReqT, RespT> callHandler) {
            this.serviceDescriptor = serviceDescriptor;
            this.interceptor = interceptor;
            this.callHandler = callHandler;
        }

        public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> call, Metadata headers) {
            Context context = Contexts.context().orElse(Context.create());
            if (this.serviceDescriptor != null) {
                context.register(GrpcServiceDescriptor.class, (Object)this.serviceDescriptor);
            }
            return (ServerCall.Listener)Contexts.runInContext((Context)context, () -> this.interceptor.interceptCall(call, headers, this.callHandler));
        }
    }
}

