/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webserver.grpc.GrpcConfigBlueprint;
import io.helidon.webserver.grpc.spi.GrpcServerService;
import io.helidon.webserver.grpc.spi.GrpcServerServiceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.grpc.GrpcConfigBlueprint")
public interface GrpcConfig
extends GrpcConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcConfig instance) {
        return (Builder)GrpcConfig.builder().from(instance);
    }

    public static GrpcConfig create(Config config) {
        return ((Builder)GrpcConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static GrpcConfig create(io.helidon.common.config.Config config) {
        return GrpcConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static GrpcConfig create() {
        return GrpcConfig.builder().buildPrototype();
    }

    @Override
    public String name();

    @Override
    public String type();

    @Override
    public boolean enableMetrics();

    @Override
    public boolean enableCompression();

    @Override
    default public List<GrpcServerService> grpcServices() {
        return GrpcConfigBlueprint.super.grpcServices();
    }

    @Override
    public int maxReadBufferSize();

    public static class Builder
    extends BuilderBase<Builder, GrpcConfig>
    implements io.helidon.common.Builder<Builder, GrpcConfig> {
        private Builder() {
        }

        public GrpcConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcConfigImpl(this);
        }

        public GrpcConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<GrpcServerService> grpcServices = new ArrayList<GrpcServerService>();
        private boolean enableCompression = true;
        private boolean enableMetrics = false;
        private boolean grpcServicesDiscoverServices = false;
        private boolean isGrpcServicesMutated;
        private Config config;
        private int maxReadBufferSize = 0x200000;
        private String name = "grpc";
        private String type = "grpc";

        protected BuilderBase() {
        }

        public BUILDER from(GrpcConfig prototype) {
            this.name(prototype.name());
            this.type(prototype.type());
            this.enableMetrics(prototype.enableMetrics());
            this.enableCompression(prototype.enableCompression());
            if (!this.isGrpcServicesMutated) {
                this.grpcServices.clear();
            }
            this.addGrpcServices(prototype.grpcServices());
            this.grpcServicesDiscoverServices = false;
            this.maxReadBufferSize(prototype.maxReadBufferSize());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            this.type(builder.type());
            this.enableMetrics(builder.enableMetrics());
            this.enableCompression(builder.enableCompression());
            if (this.isGrpcServicesMutated) {
                if (builder.isGrpcServicesMutated) {
                    this.addGrpcServices(builder.grpcServices);
                }
            } else {
                this.grpcServices.clear();
                this.addGrpcServices(builder.grpcServices);
            }
            this.grpcServicesDiscoverServices = builder.grpcServicesDiscoverServices;
            this.maxReadBufferSize(builder.maxReadBufferSize());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enable-metrics").as(Boolean.class).ifPresent(this::enableMetrics);
            config.get("enable-compression").as(Boolean.class).ifPresent(this::enableCompression);
            config.get("max-read-buffer-size").as(Integer.class).ifPresent(this::maxReadBufferSize);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER type(String type) {
            Objects.requireNonNull(type);
            this.type = type;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enableCompression(boolean enableCompression) {
            this.enableCompression = enableCompression;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER grpcServicesDiscoverServices(boolean discoverServices) {
            this.grpcServicesDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER grpcServices(List<? extends GrpcServerService> grpcServices) {
            Objects.requireNonNull(grpcServices);
            this.isGrpcServicesMutated = true;
            this.grpcServices.clear();
            this.grpcServices.addAll(grpcServices);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addGrpcServices(List<? extends GrpcServerService> grpcServices) {
            Objects.requireNonNull(grpcServices);
            this.isGrpcServicesMutated = true;
            this.grpcServices.addAll(grpcServices);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addGrpcService(GrpcServerService grpcService) {
            Objects.requireNonNull(grpcService);
            this.grpcServices.add(grpcService);
            this.isGrpcServicesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxReadBufferSize(int maxReadBufferSize) {
            this.maxReadBufferSize = maxReadBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public String type() {
            return this.type;
        }

        public boolean enableMetrics() {
            return this.enableMetrics;
        }

        public boolean enableCompression() {
            return this.enableCompression;
        }

        public List<GrpcServerService> grpcServices() {
            return this.grpcServices;
        }

        public int maxReadBufferSize() {
            return this.maxReadBufferSize;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcConfigBuilder{name=" + this.name + ",type=" + this.type + ",enableMetrics=" + this.enableMetrics + ",enableCompression=" + this.enableCompression + ",grpcServices=" + String.valueOf(this.grpcServices) + ",maxReadBufferSize=" + this.maxReadBufferSize + "}";
        }

        protected void preBuildPrototype() {
            Config config = this.config == null ? Config.empty() : this.config;
            this.addGrpcServices(ConfigBuilderSupport.discoverServices((Config)config, (String)"grpc-services", GrpcServerServiceProvider.class, GrpcServerService.class, (boolean)this.grpcServicesDiscoverServices, this.grpcServices));
        }

        protected void validatePrototype() {
        }

        protected static class GrpcConfigImpl
        implements GrpcConfig {
            private final boolean enableCompression;
            private final boolean enableMetrics;
            private final int maxReadBufferSize;
            private final List<GrpcServerService> grpcServices;
            private final String name;
            private final String type;

            protected GrpcConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.type = builder.type();
                this.enableMetrics = builder.enableMetrics();
                this.enableCompression = builder.enableCompression();
                this.grpcServices = List.copyOf(builder.grpcServices());
                this.maxReadBufferSize = builder.maxReadBufferSize();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String type() {
                return this.type;
            }

            @Override
            public boolean enableMetrics() {
                return this.enableMetrics;
            }

            @Override
            public boolean enableCompression() {
                return this.enableCompression;
            }

            @Override
            public List<GrpcServerService> grpcServices() {
                return this.grpcServices;
            }

            @Override
            public int maxReadBufferSize() {
                return this.maxReadBufferSize;
            }

            public String toString() {
                return "GrpcConfig{name=" + this.name + ",type=" + this.type + ",enableMetrics=" + this.enableMetrics + ",enableCompression=" + this.enableCompression + ",grpcServices=" + String.valueOf(this.grpcServices) + ",maxReadBufferSize=" + this.maxReadBufferSize + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcConfig)) {
                    return false;
                }
                GrpcConfig other = (GrpcConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.type, other.type()) && this.enableMetrics == other.enableMetrics() && this.enableCompression == other.enableCompression() && Objects.equals(this.grpcServices, other.grpcServices()) && this.maxReadBufferSize == other.maxReadBufferSize();
            }

            public int hashCode() {
                return Objects.hash(this.name, this.type, this.enableMetrics, this.enableCompression, this.grpcServices, this.maxReadBufferSize);
            }
        }
    }
}

