/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.helidon.common.Weight;
import io.helidon.grpc.core.ContextKeys;
import io.helidon.grpc.core.GrpcHelper;
import io.helidon.webserver.grpc.GrpcMethodDescriptor;
import io.helidon.webserver.grpc.GrpcServiceDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Weight(value=5000.0)
class ContextSettingServerInterceptor
implements ServerInterceptor {
    private static final ContextSettingServerInterceptor INSTANCE = new ContextSettingServerInterceptor();

    private ContextSettingServerInterceptor() {
    }

    static ContextSettingServerInterceptor instance() {
        return INSTANCE;
    }

    public <ReqT, ResT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, ResT> call, Metadata headers, ServerCallHandler<ReqT, ResT> next) {
        GrpcServiceDescriptor serviceDescriptor;
        Context context = Context.current();
        Optional helidonContext = io.helidon.common.context.Contexts.context();
        context = context.withValue(ContextKeys.HELIDON_CONTEXT, (Object)helidonContext.orElseGet(io.helidon.common.context.Context::create));
        if (helidonContext.isPresent() && (serviceDescriptor = (GrpcServiceDescriptor)((io.helidon.common.context.Context)helidonContext.get()).get(GrpcServiceDescriptor.class, GrpcServiceDescriptor.class).orElse(null)) != null) {
            String fullMethodName = call.getMethodDescriptor().getFullMethodName();
            String methodName = GrpcHelper.extractMethodName((String)fullMethodName);
            GrpcMethodDescriptor<?, ?> methodDescriptor = serviceDescriptor.method(methodName);
            HashMap contextMap = new HashMap();
            contextMap.putAll(serviceDescriptor.context());
            contextMap.putAll(methodDescriptor.context());
            contextMap.put(GrpcServiceDescriptor.SERVICE_DESCRIPTOR_KEY, serviceDescriptor);
            for (Map.Entry entry : contextMap.entrySet()) {
                Context.Key key = (Context.Key)entry.getKey();
                context = context.withValue(key, entry.getValue());
            }
        }
        return Contexts.interceptCall((Context)context, call, (Metadata)headers, next);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

