/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.helidon.webserver.grpc.GrpcServiceDescriptor;

class BindableServiceImpl
implements BindableService {
    private final GrpcServiceDescriptor descriptor;

    private BindableServiceImpl(GrpcServiceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    static BindableServiceImpl create(GrpcServiceDescriptor descriptor) {
        return new BindableServiceImpl(descriptor);
    }

    GrpcServiceDescriptor serviceDescriptor() {
        return this.descriptor;
    }

    public ServerServiceDefinition bindService() {
        ServiceDescriptor.Builder serviceDescriptorBuilder = ServiceDescriptor.newBuilder((String)this.descriptor.fullName());
        if (this.descriptor.proto() != null) {
            serviceDescriptorBuilder.setSchemaDescriptor(this.descriptor::proto);
        }
        this.descriptor.methods().forEach(method -> serviceDescriptorBuilder.addMethod(method.descriptor()));
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)serviceDescriptorBuilder.build());
        this.descriptor.methods().forEach(method -> builder.addMethod(method.descriptor(), method.callHandler()));
        return builder.build();
    }
}

