/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context;

import io.helidon.common.Weighted;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.webserver.context.ContextFeatureConfig;
import io.helidon.webserver.context.PropagationRecord;
import io.helidon.webserver.http.FilterChain;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import java.util.List;

class ContextRoutingFeature
implements HttpFeature,
Weighted {
    private final ContextFeatureConfig config;
    private final List<PropagationRecord> propagations;

    ContextRoutingFeature(ContextFeatureConfig config) {
        this.config = config;
        this.propagations = config.records().stream().map(PropagationRecord::create).toList();
    }

    public void setup(HttpRouting.Builder routing) {
        if (this.propagations.isEmpty()) {
            routing.addFilter(this::filter);
        } else {
            routing.addFilter(this::propagationFilter);
        }
    }

    public double weight() {
        return this.config.weight();
    }

    private void propagationFilter(FilterChain chain, RoutingRequest req, RoutingResponse res) {
        ServerRequestHeaders headers = req.headers();
        Context context = req.context();
        for (PropagationRecord propagation : this.propagations) {
            propagation.apply(headers, context);
        }
        this.filter(chain, req, res);
    }

    private void filter(FilterChain chain, RoutingRequest req, RoutingResponse res) {
        Contexts.runInContext((Context)req.context(), () -> ((FilterChain)chain).proceed());
    }
}

