/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.context.http.ContextRecordConfig;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webserver.context.ContextFeature;
import io.helidon.webserver.context.ContextFeatureConfigBlueprint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.context.ContextFeatureConfigBlueprint")
public interface ContextFeatureConfig
extends ContextFeatureConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContextFeatureConfig instance) {
        return (Builder)ContextFeatureConfig.builder().from(instance);
    }

    public static ContextFeatureConfig create(Config config) {
        return ((Builder)ContextFeatureConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static ContextFeatureConfig create(io.helidon.common.config.Config config) {
        return ContextFeatureConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static ContextFeatureConfig create() {
        return ContextFeatureConfig.builder().buildPrototype();
    }

    @Override
    public double weight();

    @Override
    public Set<String> sockets();

    @Override
    public String name();

    @Override
    public List<ContextRecordConfig> records();

    public static class Builder
    extends BuilderBase<Builder, ContextFeatureConfig>
    implements io.helidon.common.Builder<Builder, ContextFeature> {
        private Builder() {
        }

        public ContextFeatureConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ContextFeatureConfigImpl(this);
        }

        public ContextFeature build() {
            return ContextFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ContextFeatureConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<ContextRecordConfig> records = new ArrayList<ContextRecordConfig>();
        private final Set<String> sockets = new LinkedHashSet<String>();
        private boolean isRecordsMutated;
        private Config config;
        private double weight = 1100.0;
        private String name = "context";

        protected BuilderBase() {
        }

        public BUILDER from(ContextFeatureConfig prototype) {
            this.weight(prototype.weight());
            this.addSockets(prototype.sockets());
            this.name(prototype.name());
            if (!this.isRecordsMutated) {
                this.records.clear();
            }
            this.addRecords(prototype.records());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.weight(builder.weight());
            this.addSockets(builder.sockets);
            this.name(builder.name());
            if (this.isRecordsMutated) {
                if (builder.isRecordsMutated) {
                    this.addRecords(builder.records);
                }
            } else {
                this.records.clear();
                this.addRecords(builder.records);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            config.get("records").asList(ContextRecordConfig::create).ifPresent(this::records);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER records(List<? extends ContextRecordConfig> records) {
            Objects.requireNonNull(records);
            this.isRecordsMutated = true;
            this.records.clear();
            this.records.addAll(records);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRecords(List<? extends ContextRecordConfig> records) {
            Objects.requireNonNull(records);
            this.isRecordsMutated = true;
            this.records.addAll(records);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRecord(ContextRecordConfig record) {
            Objects.requireNonNull(record);
            this.records.add(record);
            this.isRecordsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRecord(Consumer<ContextRecordConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ContextRecordConfig.Builder builder = ContextRecordConfig.builder();
            consumer.accept(builder);
            this.records.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public double weight() {
            return this.weight;
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public String name() {
            return this.name;
        }

        public List<ContextRecordConfig> records() {
            return this.records;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ContextFeatureConfigBuilder{weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",records=" + String.valueOf(this.records) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class ContextFeatureConfigImpl
        implements ContextFeatureConfig,
        Supplier<ContextFeature> {
            private final double weight;
            private final List<ContextRecordConfig> records;
            private final Set<String> sockets;
            private final String name;

            protected ContextFeatureConfigImpl(BuilderBase<?, ?> builder) {
                this.weight = builder.weight();
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
                this.name = builder.name();
                this.records = List.copyOf(builder.records());
            }

            public ContextFeature build() {
                return ContextFeature.create(this);
            }

            @Override
            public ContextFeature get() {
                return this.build();
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public List<ContextRecordConfig> records() {
                return this.records;
            }

            public String toString() {
                return "ContextFeatureConfig{weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",records=" + String.valueOf(this.records) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContextFeatureConfig)) {
                    return false;
                }
                ContextFeatureConfig other = (ContextFeatureConfig)o;
                return this.weight == other.weight() && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.name, other.name()) && Objects.equals(this.records, other.records());
            }

            public int hashCode() {
                return Objects.hash(this.weight, this.sockets, this.name, this.records);
            }
        }
    }
}

