/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.config.Config;
import io.helidon.webserver.context.ContextFeatureConfig;
import io.helidon.webserver.context.ContextRoutingFeature;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.spi.ServerFeature;
import java.util.Set;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=ContextFeatureConfig.class)
public class ContextFeature
implements Weighted,
ServerFeature,
RuntimeType.Api<ContextFeatureConfig> {
    public static final double WEIGHT = 1100.0;
    static final String CONTEXT_ID = "context";
    private final ContextFeatureConfig config;

    ContextFeature(ContextFeatureConfig config) {
        this.config = config;
    }

    public static ContextFeatureConfig.Builder builder() {
        return ContextFeatureConfig.builder();
    }

    public static ContextFeature create(ContextFeatureConfig config) {
        return new ContextFeature(config);
    }

    public static ContextFeature create(Consumer<ContextFeatureConfig.Builder> builderConsumer) {
        return ((ContextFeatureConfig.Builder)ContextFeature.builder().update(builderConsumer)).build();
    }

    public static ContextFeature create() {
        return ContextFeature.builder().build();
    }

    public static ContextFeature create(Config config) {
        return ((ContextFeatureConfig.Builder)ContextFeature.builder().config(config)).build();
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        Set<String> sockets = this.config.sockets();
        featureContext.socket("@default").httpRouting().addFeature((HttpFeature)new ContextRoutingFeature(this.config));
        for (String socket : sockets) {
            featureContext.socket(socket).httpRouting().addFeature((HttpFeature)new ContextRoutingFeature(this.config));
        }
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return CONTEXT_ID;
    }

    public ContextFeatureConfig prototype() {
        return this.config;
    }

    public double weight() {
        return this.config.weight();
    }
}

