/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;

public final class HostLogEntry
extends AbstractLogEntry {
    private HostLogEntry(Builder builder) {
        super(builder);
    }

    public static HostLogEntry create() {
        return HostLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder().defaults();
    }

    @Override
    protected String doApply(AccessLogContext context) {
        String remoteAddress = context.serverRequest().remotePeer().host();
        return null == remoteAddress ? "-" : remoteAddress;
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<HostLogEntry, Builder> {
        private Builder() {
        }

        public HostLogEntry build() {
            return new HostLogEntry(this);
        }

        private Builder defaults() {
            return (Builder)super.sanitize(false);
        }
    }
}

