/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;
import java.util.List;

public final class HeaderLogEntry
extends AbstractLogEntry {
    private final HeaderName headerName;

    private HeaderLogEntry(Builder builder) {
        super(builder);
        this.headerName = builder.headerName;
    }

    public static HeaderLogEntry create(String headerName) {
        return HeaderLogEntry.builder(headerName).build();
    }

    public static Builder builder(String headerName) {
        return new Builder(headerName);
    }

    public static Builder builder(HeaderName headerName) {
        return new Builder(headerName);
    }

    @Override
    protected String doApply(AccessLogContext context) {
        List values = context.serverRequest().headers().all(this.headerName, List::of);
        if (values.isEmpty()) {
            return "-";
        }
        if (values.size() == 1) {
            return "\"" + (String)values.get(0) + "\"";
        }
        return "\"" + String.join((CharSequence)",", values) + "\"";
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<HeaderLogEntry, Builder> {
        private final HeaderName headerName;

        private Builder(String headerName) {
            this.headerName = HeaderNames.create((String)headerName);
        }

        public Builder(HeaderName headerName) {
            this.headerName = headerName;
        }

        public HeaderLogEntry build() {
            return new HeaderLogEntry(this);
        }
    }
}

