/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.config.Config;
import io.helidon.webserver.accesslog.AccessLogConfig;
import io.helidon.webserver.accesslog.AccessLogEntry;
import io.helidon.webserver.accesslog.AccessLogHttpFeature;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.spi.ServerFeature;
import java.time.Clock;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=AccessLogConfig.class)
public final class AccessLogFeature
implements Weighted,
ServerFeature,
RuntimeType.Api<AccessLogConfig> {
    public static final String DEFAULT_LOGGER_NAME = "io.helidon.webserver.AccessLog";
    static final String ACCESS_LOG_ID = "access-log";
    static final double WEIGHT = 1000.0;
    private final List<AccessLogEntry> logFormat;
    private final boolean enabled;
    private final Clock clock;
    private final double weight;
    private final AccessLogConfig config;
    private final String loggerName;

    private AccessLogFeature(AccessLogConfig config) {
        this.config = config;
        this.enabled = config.enabled();
        this.logFormat = config.entries();
        this.clock = config.clock();
        this.loggerName = config.loggerName();
        this.weight = config.weight();
    }

    public static AccessLogFeature create() {
        return AccessLogFeature.builder().build();
    }

    public static AccessLogFeature create(Config config) {
        return ((AccessLogConfig.Builder)AccessLogFeature.builder().config((io.helidon.common.config.Config)config)).build();
    }

    public static AccessLogConfig.Builder builder() {
        return AccessLogConfig.builder();
    }

    public static AccessLogFeature create(AccessLogConfig config) {
        return new AccessLogFeature(config);
    }

    public static AccessLogFeature create(Consumer<AccessLogConfig.Builder> builderConsumer) {
        return ((AccessLogConfig.Builder)AccessLogFeature.builder().update(builderConsumer)).build();
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        if (!this.enabled) {
            return;
        }
        HashSet<String> sockets = new HashSet<String>(this.config.sockets());
        if (sockets.isEmpty()) {
            sockets.addAll(featureContext.sockets());
            sockets.add("@default");
        }
        for (String socket : sockets) {
            HttpRouting.Builder httpRouting = featureContext.socket(socket).httpRouting();
            httpRouting.addFeature((HttpFeature)this.httpFeature(socket));
        }
    }

    public AccessLogConfig prototype() {
        return this.config;
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return ACCESS_LOG_ID;
    }

    public double weight() {
        return this.config.weight();
    }

    AccessLogHttpFeature httpFeature(String socketName) {
        return new AccessLogHttpFeature(this.weight, this.clock, this.logFormat, this.loggerName, socketName);
    }
}

