/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.webserver.accesslog.AccessLogConfigSupport;
import io.helidon.webserver.accesslog.AccessLogEntry;
import io.helidon.webserver.accesslog.AccessLogFeature;
import io.helidon.webserver.accesslog.HostLogEntry;
import io.helidon.webserver.accesslog.RequestLineLogEntry;
import io.helidon.webserver.accesslog.SizeLogEntry;
import io.helidon.webserver.accesslog.StatusLogEntry;
import io.helidon.webserver.accesslog.TimeTakenLogEntry;
import io.helidon.webserver.accesslog.TimestampLogEntry;
import io.helidon.webserver.accesslog.UserIdLogEntry;
import io.helidon.webserver.accesslog.UserLogEntry;
import io.helidon.webserver.spi.ServerFeatureProvider;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint(decorator=AccessLogConfigSupport.BuilderDecorator.class)
@Prototype.Configured(value="access-log", root=false)
@Prototype.CustomMethods(value=AccessLogConfigSupport.CustomMethods.class)
@Prototype.Provides(value={ServerFeatureProvider.class})
interface AccessLogConfigBlueprint
extends Prototype.Factory<AccessLogFeature> {
    public static final List<AccessLogEntry> COMMON_FORMAT = List.of(HostLogEntry.create(), UserIdLogEntry.create(), UserLogEntry.create(), TimestampLogEntry.create(), RequestLineLogEntry.create(), StatusLogEntry.create(), SizeLogEntry.create());
    public static final List<AccessLogEntry> HELIDON_FORMAT = List.of(HostLogEntry.create(), UserLogEntry.create(), TimestampLogEntry.create(), RequestLineLogEntry.create(), StatusLogEntry.create(), SizeLogEntry.create(), TimeTakenLogEntry.create());

    @Option.Singular(value="entry")
    public List<AccessLogEntry> entries();

    @Option.DefaultCode(value="@java.time.Clock@.systemDefaultZone()")
    public Clock clock();

    @Option.Configured
    @Option.Default(value={"io.helidon.webserver.AccessLog"})
    public String loggerName();

    @Option.DefaultDouble(value={1000.0})
    @Option.Configured
    public double weight();

    @Option.Configured
    public Set<String> sockets();

    @Option.Default(value={"access-log"})
    public String name();

    @Option.Configured
    public Optional<String> format();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean enabled();
}

