/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.webserver.accesslog.AccessLogContext;
import io.helidon.webserver.accesslog.AccessLogEntry;
import java.text.Normalizer;
import java.util.function.Function;
import java.util.regex.Pattern;

public abstract class AbstractLogEntry
implements AccessLogEntry {
    public static final int DEFAULT_MAX_LENGTH = 512;
    static final char QUOTES = '\"';
    static final char SPACE = ' ';
    private final Function<String, String> padding;
    private final Function<String, String> sanitization;
    private final int maxLength;

    protected AbstractLogEntry(Builder<?, ?> builder) {
        this.padding = builder.padding;
        this.sanitization = builder.sanitizationFunction();
        this.maxLength = builder.maxLength;
    }

    @Override
    public String apply(AccessLogContext context) {
        return this.pad(this.maxLength(this.sanitize(this.doApply(context))));
    }

    protected String maxLength(String toLimit) {
        if (toLimit.length() > this.maxLength) {
            if (toLimit.charAt(0) == '!') {
                return toLimit.substring(0, this.maxLength);
            }
            return "!" + toLimit.substring(0, this.maxLength - 1);
        }
        return toLimit;
    }

    protected String sanitize(String toSanitize) {
        return this.sanitization.apply(toSanitize);
    }

    protected String pad(String toPad) {
        return this.padding.apply(toPad);
    }

    protected abstract String doApply(AccessLogContext var1);

    protected static abstract class Builder<R extends AbstractLogEntry, T extends Builder<R, T>>
    implements io.helidon.common.Builder<T, R> {
        private static final Pattern SANITIZE_PATTERN = Pattern.compile("[^\\p{Print}]", 256);
        private Function<String, String> padding = Function.identity();
        private boolean sanitize = true;
        private int maxLength = 512;

        protected Builder() {
        }

        public T noPad() {
            this.padding = Function.identity();
            return (T)((Builder)this.identity());
        }

        public T rPad(int length) {
            this.padding = orig -> {
                if (orig.length() >= length) {
                    return orig;
                }
                StringBuilder builder = new StringBuilder(length);
                builder.append((String)orig);
                for (int i = 0; i < length - orig.length(); ++i) {
                    builder.append(' ');
                }
                return builder.toString();
            };
            return (T)((Builder)this.identity());
        }

        public T lPad(int length) {
            this.padding = orig -> {
                if (orig.length() >= length) {
                    return orig;
                }
                StringBuilder builder = new StringBuilder(length);
                for (int i = 0; i < length - orig.length(); ++i) {
                    builder.append(' ');
                }
                builder.append((String)orig);
                return builder.toString();
            };
            return (T)((Builder)this.identity());
        }

        public T sanitize(boolean sanitize) {
            this.sanitize = sanitize;
            return (T)((Builder)this.identity());
        }

        public T maxLength(int maxLength) {
            this.maxLength = maxLength;
            return (T)((Builder)this.identity());
        }

        private Function<String, String> sanitizationFunction() {
            if (this.sanitize) {
                return s -> {
                    String result = Normalizer.normalize(s, Normalizer.Form.NFKC);
                    if (s.equals(result = SANITIZE_PATTERN.matcher(result).replaceAll(""))) {
                        return s;
                    }
                    return "!" + result;
                };
            }
            return Function.identity();
        }
    }
}

