/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;
import java.util.concurrent.TimeUnit;

public final class TimeTakenLogEntry
extends AbstractLogEntry {
    private final TimeUnit unit;

    private TimeTakenLogEntry(Builder builder) {
        super(builder);
        this.unit = builder.unit;
    }

    public static TimeTakenLogEntry create() {
        return TimeTakenLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder().defaults();
    }

    @Override
    protected String doApply(AccessLogContext context) {
        long req = context.requestNanoTime();
        long res = context.responseNanoTime();
        long diff = res - req;
        return String.valueOf(this.unit.convert(diff, TimeUnit.NANOSECONDS));
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<TimeTakenLogEntry, Builder> {
        private TimeUnit unit = TimeUnit.MICROSECONDS;

        private Builder() {
        }

        public TimeTakenLogEntry build() {
            return new TimeTakenLogEntry(this);
        }

        public Builder unit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        private Builder defaults() {
            return (Builder)super.sanitize(false);
        }
    }
}

