/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.BufferedEmittingPublisher;
import io.helidon.common.reactive.Single;
import io.helidon.webclient.HttpInterceptor;
import io.helidon.webclient.RedirectInterceptor;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestImpl;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientResponseHeaders;
import io.helidon.webclient.WebClientResponseImpl;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.WebClientServiceResponseImpl;
import io.helidon.webclient.spi.WebClientService;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOGGER = Logger.getLogger(NettyClientHandler.class.getName());
    private static final AttributeKey<WebClientServiceResponse> SERVICE_RESPONSE = AttributeKey.valueOf((String)"serviceResponse");
    static final AttributeKey<BufferedEmittingPublisher> PUBLISHER = AttributeKey.valueOf((String)"publisher");
    private static final List<HttpInterceptor> HTTP_INTERCEPTORS = new ArrayList<HttpInterceptor>();
    private HttpResponsePublisher publisher;
    private ResponseCloser responseCloser;
    private long requestId;

    NettyClientHandler() {
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        ctx.flush();
        if (this.publisher != null && this.publisher.hasRequests()) {
            channel.read();
        }
        if (!((Boolean)channel.attr(WebClientRequestBuilderImpl.WILL_CLOSE).get()).booleanValue() && channel.hasAttr(WebClientRequestBuilderImpl.RETURN) && ((AtomicBoolean)channel.attr(WebClientRequestBuilderImpl.RETURN).get()).compareAndSet(true, false)) {
            LOGGER.finest(() -> "(client reqID: " + this.requestId + ") Returning channel " + channel.hashCode() + " to the cache");
            ((AtomicBoolean)channel.attr(WebClientRequestBuilderImpl.IN_USE).get()).set(false);
            this.responseCloser.cf.complete(null);
            this.publisher.complete();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws IOException {
        Channel channel = ctx.channel();
        if (msg instanceof HttpResponse) {
            channel.config().setAutoRead(false);
            HttpResponse response = (HttpResponse)msg;
            this.requestId = (Long)channel.attr(WebClientRequestBuilderImpl.REQUEST_ID).get();
            channel.attr(WebClientRequestBuilderImpl.RESPONSE_RECEIVED).set((Object)true);
            WebClientRequestImpl clientRequest = (WebClientRequestImpl)channel.attr(WebClientRequestBuilderImpl.REQUEST).get();
            RequestConfiguration requestConfiguration = clientRequest.configuration();
            LOGGER.finest(() -> "(client reqID: " + this.requestId + ") Initial http response message received");
            this.publisher = new HttpResponsePublisher(ctx);
            channel.attr(PUBLISHER).set((Object)this.publisher);
            this.responseCloser = new ResponseCloser(ctx);
            WebClientResponseImpl.Builder responseBuilder = WebClientResponseImpl.builder();
            responseBuilder.contentPublisher((Flow.Publisher<DataChunk>)((Object)this.publisher)).readerContext(requestConfiguration.readerContext()).status(this.helidonStatus(response.status())).httpVersion(Http.Version.create((String)response.protocolVersion().toString())).responseCloser(this.responseCloser).lastEndpointURI(requestConfiguration.requestURI());
            HttpHeaders nettyHeaders = response.headers();
            for (String name : nettyHeaders.names()) {
                List values = nettyHeaders.getAll(name);
                responseBuilder.addHeader(name, values);
            }
            String connection = nettyHeaders.get((CharSequence)"Connection", HttpHeaderValues.CLOSE.toString());
            if (connection.equals(HttpHeaderValues.CLOSE.toString())) {
                ctx.channel().attr(WebClientRequestBuilderImpl.WILL_CLOSE).set((Object)true);
            }
            WebClientResponseImpl clientResponse = responseBuilder.build();
            channel.attr(WebClientRequestBuilderImpl.RESPONSE).set((Object)clientResponse);
            requestConfiguration.cookieManager().put(requestConfiguration.requestURI(), clientResponse.headers().toMap());
            for (HttpInterceptor interceptor : HTTP_INTERCEPTORS) {
                boolean continueAfter;
                if (!interceptor.shouldIntercept(response.status(), requestConfiguration)) continue;
                boolean bl = continueAfter = !interceptor.continueAfterInterception();
                if (continueAfter) {
                    this.responseCloser.close().thenAccept(future -> LOGGER.finest(() -> "Response closed due to redirection"));
                }
                interceptor.handleInterception(response, clientRequest, (CompletableFuture)channel.attr(WebClientRequestBuilderImpl.RESULT).get());
                if (!continueAfter) continue;
                return;
            }
            WebClientServiceResponseImpl clientServiceResponse = new WebClientServiceResponseImpl(requestConfiguration.context().get(), clientResponse.headers(), clientResponse.status());
            channel.attr(SERVICE_RESPONSE).set((Object)clientServiceResponse);
            List<WebClientService> services = requestConfiguration.services();
            CompletionStage<WebClientServiceResponseImpl> csr = CompletableFuture.completedFuture(clientServiceResponse);
            for (WebClientService service : services) {
                csr = csr.thenCompose(clientSerResponse -> service.response(clientRequest, (WebClientServiceResponse)clientSerResponse));
            }
            CompletableFuture responseReceived = (CompletableFuture)channel.attr(WebClientRequestBuilderImpl.RECEIVED).get();
            CompletableFuture responseFuture = (CompletableFuture)channel.attr(WebClientRequestBuilderImpl.RESULT).get();
            csr.whenComplete((clientSerResponse, throwable) -> {
                if (throwable != null) {
                    responseReceived.completeExceptionally((Throwable)throwable);
                    responseFuture.completeExceptionally((Throwable)throwable);
                    this.responseCloser.close();
                } else {
                    responseReceived.complete(clientServiceResponse);
                    ((CompletableFuture)responseReceived.thenRun(() -> {
                        if (this.shouldResponseAutomaticallyClose(clientResponse)) {
                            this.responseCloser.close().thenAccept(aVoid -> LOGGER.finest(() -> "Response automatically closed. No entity expected"));
                        }
                        responseFuture.complete(clientResponse);
                    })).exceptionally(t -> {
                        responseFuture.completeExceptionally((Throwable)t);
                        this.responseCloser.close();
                        return null;
                    });
                }
            });
        }
        if (this.responseCloser.isClosed()) {
            if (!((Boolean)channel.attr(WebClientRequestBuilderImpl.WILL_CLOSE).get()).booleanValue() && channel.hasAttr(WebClientRequestBuilderImpl.RETURN)) {
                if (msg instanceof LastHttpContent) {
                    LOGGER.finest(() -> "(client reqID: " + this.requestId + ") Draining finished");
                    if (channel.isActive()) {
                        ((AtomicBoolean)channel.attr(WebClientRequestBuilderImpl.RETURN).get()).set(true);
                    }
                } else {
                    LOGGER.finest(() -> "(client reqID: " + this.requestId + ") Draining not finished, requesting new chunk");
                }
                channel.read();
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.publisher.emit(content.content());
        }
        if (msg instanceof LastHttpContent) {
            LOGGER.finest(() -> "(client reqID: " + this.requestId + ") Last http content received");
            if (channel.hasAttr(WebClientRequestBuilderImpl.RETURN)) {
                ((AtomicBoolean)channel.attr(WebClientRequestBuilderImpl.RETURN).get()).set(true);
                this.responseCloser.close();
                channel.read();
            } else {
                this.responseCloser.close();
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.publisher != null && !this.responseCloser.isClosed()) {
            WebClientException exception = new WebClientException("Connection reset by the host");
            this.publisher.fail(exception);
        }
    }

    private boolean shouldResponseAutomaticallyClose(WebClientResponse clientResponse) {
        WebClientResponseHeaders headers = clientResponse.headers();
        if (clientResponse.status() == Http.Status.NO_CONTENT_204) {
            return true;
        }
        return headers.contentType().isEmpty() && this.noContentLength(headers) && this.notChunked(headers);
    }

    private boolean noContentLength(WebClientResponseHeaders headers) {
        return headers.contentLength().map(value -> value == 0L).orElse(true);
    }

    private boolean notChunked(WebClientResponseHeaders headers) {
        return !headers.transferEncoding().contains("chunked");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        CompletableFuture responseFuture = (CompletableFuture)ctx.channel().attr(WebClientRequestBuilderImpl.RESULT).get();
        if (responseFuture.isDone()) {
            if (this.publisher != null) {
                this.publisher.fail(cause);
            }
        } else {
            responseFuture.completeExceptionally(cause);
        }
        ctx.close();
    }

    private Http.ResponseStatus helidonStatus(HttpResponseStatus nettyStatus) {
        return Http.ResponseStatus.create((int)nettyStatus.code(), (String)nettyStatus.reasonPhrase());
    }

    static {
        HTTP_INTERCEPTORS.add(new RedirectInterceptor());
    }

    private static final class HttpResponsePublisher
    extends BufferedEmittingPublisher<DataChunk> {
        private final ReentrantReadWriteLock.WriteLock lock = new ReentrantReadWriteLock().writeLock();

        HttpResponsePublisher(ChannelHandlerContext ctx) {
            super.onRequest((n, cnt) -> {
                ctx.channel().config().setAutoRead(super.isUnbounded());
                try {
                    this.lock.lock();
                    if (super.hasRequests()) {
                        ctx.channel().read();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        public void emit(ByteBuf buf) {
            buf.retain();
            super.emit((Object)DataChunk.create((boolean)false, (boolean)true, () -> ((ByteBuf)buf).release(), (ByteBuffer[])new ByteBuffer[]{buf.nioBuffer().asReadOnlyBuffer()}));
        }
    }

    final class ResponseCloser {
        private final AtomicBoolean closed;
        private final ChannelHandlerContext ctx;
        private final CompletableFuture<Void> cf;

        ResponseCloser(ChannelHandlerContext ctx) {
            this.ctx = ctx;
            this.closed = new AtomicBoolean();
            this.cf = new CompletableFuture();
        }

        boolean isClosed() {
            return this.closed.get();
        }

        Single<Void> close() {
            if (this.closed.compareAndSet(false, true)) {
                LOGGER.finest(() -> "(client reqID: " + NettyClientHandler.this.requestId + ") Closing the response from the server");
                Channel channel = this.ctx.channel();
                WebClientServiceResponse clientServiceResponse = (WebClientServiceResponse)channel.attr(SERVICE_RESPONSE).get();
                CompletableFuture requestComplete = (CompletableFuture)channel.attr(WebClientRequestBuilderImpl.COMPLETED).get();
                requestComplete.complete(clientServiceResponse);
                if (((Boolean)channel.attr(WebClientRequestBuilderImpl.WILL_CLOSE).get()).booleanValue() || !channel.hasAttr(WebClientRequestBuilderImpl.RETURN)) {
                    this.ctx.close().addListener(future -> {
                        if (future.isSuccess()) {
                            LOGGER.finest(() -> "(client reqID: " + NettyClientHandler.this.requestId + ") Response from the server has been closed");
                            this.cf.complete(null);
                        } else {
                            LOGGER.log(Level.SEVERE, future.cause(), () -> "An exception occurred while closing the response");
                            this.cf.completeExceptionally(future.cause());
                        }
                    });
                    NettyClientHandler.this.publisher.complete();
                } else if (!((AtomicBoolean)channel.attr(WebClientRequestBuilderImpl.RETURN).get()).get()) {
                    LOGGER.finest(() -> "(client reqID: " + NettyClientHandler.this.requestId + ") Drain possible remaining entity parts");
                    channel.read();
                }
            }
            return Single.create(this.cf, (boolean)true);
        }
    }
}

