/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.reactive.Single;
import io.helidon.webclient.HttpInterceptor;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestImpl;
import io.helidon.webclient.WebClientResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

class RedirectInterceptor
implements HttpInterceptor {
    private static final Logger LOGGER = Logger.getLogger(RedirectInterceptor.class.getName());

    RedirectInterceptor() {
    }

    @Override
    public void handleInterception(HttpResponse httpResponse, WebClientRequestImpl clientRequest, CompletableFuture<WebClientResponse> responseFuture) {
        WebClientRequestBuilder requestBuilder;
        if (httpResponse.headers().contains("Location")) {
            long requestId = clientRequest.configuration().requestId();
            String newUri = httpResponse.headers().get("Location");
            LOGGER.finest(() -> "(client reqID: " + requestId + ") Redirecting to " + newUri);
            requestBuilder = WebClientRequestBuilderImpl.create(clientRequest);
            if (URI.create(newUri).getHost() == null) {
                URI uri = clientRequest.uri();
                Object path = newUri;
                if (!((String)path).startsWith("/")) {
                    path = "/" + (String)path;
                }
                requestBuilder.uri(uri.getScheme() + "://" + uri.getAuthority() + (String)path);
            } else {
                requestBuilder.uri(newUri);
            }
        } else {
            throw new WebClientException("There is no Location header present in response! It is not clear where to redirect.");
        }
        Single<WebClientResponse> redirectResponse = requestBuilder.request();
        redirectResponse.whenComplete((clResponse, throwable) -> {
            if (throwable == null) {
                responseFuture.complete((WebClientResponse)clResponse);
            } else {
                responseFuture.completeExceptionally((Throwable)throwable);
            }
        });
    }

    @Override
    public boolean continueAfterInterception() {
        return false;
    }

    @Override
    public boolean shouldIntercept(HttpResponseStatus responseStatus, WebClientConfiguration configuration) {
        if (!configuration.followRedirects()) {
            return false;
        }
        return responseStatus.equals((Object)HttpResponseStatus.MOVED_PERMANENTLY) || responseStatus.equals((Object)HttpResponseStatus.FOUND) || responseStatus.equals((Object)HttpResponseStatus.SEE_OTHER) || responseStatus.equals((Object)HttpResponseStatus.TEMPORARY_REDIRECT) || responseStatus.equals((Object)HttpResponseStatus.PERMANENT_REDIRECT);
    }
}

