/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.http.SetCookie;
import io.helidon.webclient.WebClientResponseHeaders;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class WebClientResponseHeadersImpl
extends ReadOnlyParameters
implements WebClientResponseHeaders {
    private final boolean mediaTypeParserRelaxed;

    private WebClientResponseHeadersImpl(Map<String, List<String>> headers, boolean mediaTypeParserRelaxed) {
        super(headers);
        this.mediaTypeParserRelaxed = mediaTypeParserRelaxed;
    }

    static WebClientResponseHeadersImpl create(Map<String, List<String>> headers, boolean mediaTypeParserRelaxed) {
        return new WebClientResponseHeadersImpl(headers, mediaTypeParserRelaxed);
    }

    static WebClientResponseHeaders create(Parameters parameters) {
        return WebClientResponseHeadersImpl.create(parameters.toMap(), false);
    }

    static WebClientResponseHeadersImpl create(Map<String, List<String>> headers) {
        return new WebClientResponseHeadersImpl(headers, false);
    }

    @Override
    public List<SetCookie> setCookies() {
        return this.all("Set-Cookie").stream().map(SetCookie::parse).collect(Collectors.toList());
    }

    @Override
    public Optional<URI> location() {
        return this.first("Location").map(URI::create);
    }

    @Override
    public Optional<ZonedDateTime> lastModified() {
        return this.first("Last-Modified").map(Http.DateTime::parse);
    }

    @Override
    public Optional<ZonedDateTime> expires() {
        return this.first("Expires").map(Http.DateTime::parse);
    }

    @Override
    public Optional<ZonedDateTime> date() {
        return this.first("Date").map(Http.DateTime::parse);
    }

    @Override
    public Optional<MediaType> contentType() {
        return this.first("Content-Type").map(this.mediaTypeParserRelaxed ? MediaType::parseRelaxed : MediaType::parse);
    }

    @Override
    public Optional<String> etag() {
        return this.first("ETag").map(this::unquoteETag);
    }

    @Override
    public Optional<Long> contentLength() {
        return this.first("Content-Length").map(Long::parseLong).or(Optional::empty);
    }

    @Override
    public List<String> transferEncoding() {
        return this.all("Transfer-Encoding");
    }

    private String unquoteETag(String etag) {
        if (etag == null || etag.isEmpty()) {
            return etag;
        }
        if (etag.startsWith("W/") || etag.startsWith("w/")) {
            etag = etag.substring(2);
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }
}

