/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;

class HelidonReadTimeoutHandler
extends ReadTimeoutHandler {
    private final long timeoutMillis;
    private boolean closed;

    HelidonReadTimeoutHandler(long timeout, TimeUnit unit) {
        super(timeout, unit);
        this.timeoutMillis = unit.toMillis(timeout);
    }

    protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            ctx.fireExceptionCaught((Throwable)new ReadTimeoutException("Read timeout after " + this.timeoutMillis + " millis on socket " + ctx.channel().localAddress()));
            ctx.close();
            this.closed = true;
        }
    }

    static class ReadTimeoutException
    extends RuntimeException {
        ReadTimeoutException(String message) {
            super(message);
        }
    }
}

