/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.LazyValue;
import io.helidon.common.context.Context;
import io.helidon.common.http.Parameters;
import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import io.helidon.media.common.MediaContext;
import io.helidon.media.common.MediaContextBuilder;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyStreamReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.common.ParentingMediaContextBuilder;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClientCookieManager;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientRequestHeadersImpl;
import io.helidon.webclient.WebClientTls;
import io.helidon.webclient.spi.WebClientService;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

class WebClientConfiguration {
    private final WebClientRequestHeaders clientHeaders;
    private final WebClientCookieManager cookieManager;
    private final CookiePolicy cookiePolicy;
    private final Config config;
    private final Context context;
    private final Duration connectTimeout;
    private final boolean enableAutomaticCookieStore;
    private final Duration readTimeout;
    private final LazyValue<String> userAgent;
    private final List<WebClientService> clientServices;
    private final Proxy proxy;
    private final boolean followRedirects;
    private final boolean keepAlive;
    private final int maxRedirects;
    private final MessageBodyReaderContext readerContext;
    private final MessageBodyWriterContext writerContext;
    private final WebClientTls webClientTls;
    private final URI uri;
    private final boolean validateHeaders;

    WebClientConfiguration(Builder<?, ?> builder) {
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.followRedirects = builder.followRedirects;
        this.userAgent = builder.userAgent;
        this.proxy = builder.proxy;
        this.webClientTls = builder.webClientTls;
        this.maxRedirects = builder.maxRedirects;
        this.clientHeaders = builder.clientHeaders;
        this.cookiePolicy = builder.cookiePolicy;
        this.enableAutomaticCookieStore = builder.enableAutomaticCookieStore;
        this.cookieManager = WebClientCookieManager.create(this.cookiePolicy, builder.cookieStore, builder.defaultCookies, this.enableAutomaticCookieStore);
        this.config = builder.config;
        this.context = builder.context;
        this.readerContext = builder.readerContext;
        this.writerContext = builder.writerContext;
        this.clientServices = Collections.unmodifiableList(builder.clientServices);
        this.uri = builder.uri;
        this.keepAlive = builder.keepAlive;
        this.validateHeaders = builder.validateHeaders;
    }

    static Builder builder() {
        return new Builder();
    }

    Builder derive() {
        return new Builder().update(this);
    }

    Optional<SslContext> sslContext() {
        SslContext sslContext;
        try {
            if (this.webClientTls.sslContext().isPresent()) {
                sslContext = this.nettySslFromJavaNet(this.webClientTls.sslContext().get());
            } else {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK);
                if (this.webClientTls.certificates().size() > 0) {
                    sslContextBuilder.trustManager(this.webClientTls.certificates().toArray(new X509Certificate[0]));
                }
                if (this.webClientTls.clientPrivateKey().isPresent()) {
                    sslContextBuilder.keyManager(this.webClientTls.clientPrivateKey().get(), this.webClientTls.clientCertificateChain().toArray(new X509Certificate[0]));
                }
                if (this.webClientTls.trustAll()) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                sslContext = sslContextBuilder.build();
            }
        }
        catch (SSLException e) {
            throw new WebClientException("An error occurred while creating ssl context.", e);
        }
        return Optional.of(sslContext);
    }

    private SslContext nettySslFromJavaNet(SSLContext javaNetContext) {
        return new JdkSslContext(javaNetContext, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, ClientAuth.OPTIONAL, null, false);
    }

    Duration connectTimeout() {
        return this.connectTimeout;
    }

    Duration readTimout() {
        return this.readTimeout;
    }

    Optional<Proxy> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    boolean followRedirects() {
        return this.followRedirects;
    }

    int maxRedirects() {
        return this.maxRedirects;
    }

    WebClientRequestHeaders headers() {
        return this.clientHeaders;
    }

    CookieManager cookieManager() {
        return this.cookieManager;
    }

    String userAgent() {
        return (String)this.userAgent.get();
    }

    WebClientTls tls() {
        return this.webClientTls;
    }

    Optional<Context> context() {
        return Optional.ofNullable(this.context);
    }

    Config config() {
        return this.config;
    }

    List<WebClientService> clientServices() {
        return this.clientServices;
    }

    MessageBodyReaderContext readerContext() {
        return this.readerContext;
    }

    MessageBodyWriterContext writerContext() {
        return this.writerContext;
    }

    URI uri() {
        return this.uri;
    }

    boolean keepAlive() {
        return this.keepAlive;
    }

    boolean validateHeaders() {
        return this.validateHeaders;
    }

    static class Builder<B extends Builder<B, T>, T extends WebClientConfiguration>
    implements io.helidon.common.Builder<T>,
    ParentingMediaContextBuilder<B>,
    MediaContextBuilder<B> {
        private final WebClientRequestHeaders clientHeaders;
        private final Map<String, String> defaultCookies;
        private Config config;
        private Context context;
        private CookieStore cookieStore;
        private CookiePolicy cookiePolicy;
        private int maxRedirects;
        private Duration connectTimeout;
        private Duration readTimeout;
        private boolean followRedirects;
        private LazyValue<String> userAgent;
        private Proxy proxy;
        private boolean enableAutomaticCookieStore;
        private boolean keepAlive;
        private WebClientTls webClientTls;
        private URI uri;
        private MessageBodyReaderContext readerContext;
        private MessageBodyWriterContext writerContext;
        private List<WebClientService> clientServices;
        private boolean validateHeaders;
        private B me = this;

        Builder() {
            this.clientHeaders = new WebClientRequestHeadersImpl();
            this.defaultCookies = new HashMap<String, String>();
            this.clientServices = new ArrayList<WebClientService>();
        }

        public T build() {
            return (T)new WebClientConfiguration(this);
        }

        public B connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.me;
        }

        public B readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this.me;
        }

        public B followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this.me;
        }

        public B userAgent(String userAgent) {
            this.userAgent = LazyValue.create(() -> userAgent);
            return this.me;
        }

        public B userAgent(LazyValue<String> userAgent) {
            this.userAgent = userAgent;
            return this.me;
        }

        public B proxy(Proxy proxy) {
            this.proxy = proxy;
            return this.me;
        }

        public B tls(WebClientTls webClientTls) {
            this.webClientTls = webClientTls;
            return this.me;
        }

        public B maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this.me;
        }

        public B clientHeaders(WebClientRequestHeaders clientHeaders) {
            this.clientHeaders.putAll((Parameters)clientHeaders);
            return this.me;
        }

        public B cookieStore(CookieStore cookieStore) {
            this.cookieStore = cookieStore;
            return this.me;
        }

        public B cookiePolicy(CookiePolicy cookiePolicy) {
            this.cookiePolicy = cookiePolicy;
            return this.me;
        }

        public B defaultCookie(String key, String value) {
            this.defaultCookies.put(key, value);
            return this.me;
        }

        public B defaultHeader(String key, List<String> values) {
            this.clientHeaders.put(key, values);
            return this.me;
        }

        public B mediaContext(MediaContext mediaContext) {
            this.writerContextParent(mediaContext.writerContext());
            this.readerContextParent(mediaContext.readerContext());
            return this.me;
        }

        public B context(Context context) {
            this.context = context;
            return this.me;
        }

        public B uri(URI uri) {
            this.uri = uri;
            return this.me;
        }

        B validateHeaders(boolean validate) {
            this.validateHeaders = validate;
            return this.me;
        }

        public B addReader(MessageBodyReader<?> reader) {
            this.readerContext.registerReader(reader);
            return this.me;
        }

        public B addStreamReader(MessageBodyStreamReader<?> streamReader) {
            this.readerContext.registerReader(streamReader);
            return this.me;
        }

        public B addWriter(MessageBodyWriter<?> writer) {
            this.writerContext.registerWriter(writer);
            return this.me;
        }

        public B addStreamWriter(MessageBodyStreamWriter<?> streamWriter) {
            this.writerContext.registerWriter(streamWriter);
            return this.me;
        }

        public B addMediaSupport(MediaSupport mediaSupport) {
            Objects.requireNonNull(mediaSupport);
            mediaSupport.register(this.readerContext, this.writerContext);
            return this.me;
        }

        private B enableAutomaticCookieStore(Boolean enableAutomaticCookieStore) {
            this.enableAutomaticCookieStore = enableAutomaticCookieStore;
            return this.me;
        }

        B readerContextParent(MessageBodyReaderContext readerContext) {
            this.readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)readerContext);
            return this.me;
        }

        B writerContextParent(MessageBodyWriterContext writerContext) {
            this.writerContext = MessageBodyWriterContext.create((MessageBodyWriterContext)writerContext);
            return this.me;
        }

        B readerContext(MessageBodyReaderContext readerContext) {
            this.readerContext = readerContext;
            return this.me;
        }

        B writerContext(MessageBodyWriterContext writerContext) {
            this.writerContext = writerContext;
            return this.me;
        }

        B clientServices(List<WebClientService> clientServices) {
            this.clientServices = clientServices;
            return this.me;
        }

        B keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this.me;
        }

        public B config(Config config) {
            this.config = config;
            config.get("uri").asString().ifPresent(baseUri -> this.uri(URI.create(baseUri)));
            config.get("connect-timeout-millis").asLong().ifPresent(timeout -> this.connectTimeout(Duration.ofMillis(timeout)));
            config.get("read-timeout-millis").asLong().ifPresent(timeout -> this.readTimeout(Duration.ofMillis(timeout)));
            config.get("follow-redirects").asBoolean().ifPresent(this::followRedirects);
            config.get("max-redirects").asInt().ifPresent(this::maxRedirects);
            config.get("user-agent").asString().ifPresent(this::userAgent);
            config.get("keep-alive").asBoolean().ifPresent(this::keepAlive);
            config.get("cookies").asNode().ifPresent(this::cookies);
            config.get("headers").asNode().ifPresent(this::headers);
            DeprecatedConfig.get((Config)config, (String)"tls", (String)"ssl").as(WebClientTls.builder()::config).map(WebClientTls.Builder::build).ifPresent(this::tls);
            config.get("proxy").as(Proxy.builder()::config).map(Proxy.Builder::build).ifPresent(this::proxy);
            config.get("media-support").as(MediaContext::create).ifPresent(mediaContext -> this.mediaContext((MediaContext)mediaContext));
            return this.me;
        }

        public B update(WebClientConfiguration configuration) {
            this.connectTimeout(configuration.connectTimeout);
            this.readTimeout(configuration.readTimeout);
            this.followRedirects(configuration.followRedirects);
            this.userAgent(configuration.userAgent);
            this.proxy(configuration.proxy);
            this.tls(configuration.webClientTls);
            this.maxRedirects(configuration.maxRedirects);
            this.clientHeaders(configuration.clientHeaders);
            this.enableAutomaticCookieStore(configuration.enableAutomaticCookieStore);
            this.cookieStore(configuration.cookieManager.getCookieStore());
            this.cookiePolicy(configuration.cookiePolicy);
            this.clientServices(configuration.clientServices);
            this.readerContextParent(configuration.readerContext);
            this.writerContextParent(configuration.writerContext);
            this.context(configuration.context);
            this.keepAlive(configuration.keepAlive);
            this.validateHeaders(configuration.validateHeaders);
            configuration.cookieManager.defaultCookies().forEach(this::defaultCookie);
            this.config = configuration.config;
            return this.me;
        }

        private void headers(Config configHeaders) {
            configHeaders.asNodeList().ifPresent(headers -> headers.forEach(header -> this.defaultHeader((String)header.get("name").asString().get(), (List)header.get("value").asList(String.class).get())));
        }

        private void cookies(Config cookies) {
            cookies.get("automatic-store-enabled").asBoolean().ifPresent(this::enableAutomaticCookieStore);
            Config map = cookies.get("default-cookies");
            map.asNodeList().ifPresent(headers -> headers.forEach(header -> this.defaultCookie((String)header.get("name").asString().get(), (String)header.get("value").asString().get())));
        }
    }
}

