/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.DataChunk;
import io.helidon.webclient.WebClientException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public final class FileSubscriber
implements Flow.Subscriber<DataChunk> {
    private static final Logger LOGGER = Logger.getLogger(FileSubscriber.class.getName());
    private final CompletableFuture<Path> resultFuture = new CompletableFuture();
    private final Path filePath;
    private final Path tempPath;
    private final FileChannel channel;
    private Flow.Subscription subscription;

    private FileSubscriber(Path filePath, Path tempPath, FileChannel channel) {
        this.filePath = filePath;
        this.tempPath = tempPath;
        this.channel = channel;
    }

    public CompletionStage<Path> subscribeTo(Flow.Publisher<DataChunk> publisher) {
        publisher.subscribe(this);
        return this.resultFuture;
    }

    public static FileSubscriber create(Path filePath) {
        if (Files.exists(filePath, new LinkOption[0])) {
            throw new WebClientException("Path " + filePath.toAbsolutePath() + " already exists, cannot download into it");
        }
        try {
            Path tempPath = Files.createTempFile("helidon-large", ".tmp", new FileAttribute[0]);
            FileChannel channel = FileChannel.open(tempPath, StandardOpenOption.WRITE);
            return new FileSubscriber(filePath, tempPath, channel);
        }
        catch (IOException e) {
            throw new WebClientException("Failed to open temporary file", e);
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(DataChunk item) {
        try {
            this.channel.write(item.data());
            this.subscription.request(1L);
        }
        catch (IOException e) {
            throw new WebClientException("Failed to write data to temporary file: " + this.tempPath.toAbsolutePath(), e);
        }
        finally {
            item.release();
        }
    }

    @Override
    public void onError(Throwable throwable) {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Received an onError", e);
        }
        this.resultFuture.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        try {
            this.channel.close();
            Files.move(this.tempPath, this.filePath, new CopyOption[0]);
            this.resultFuture.complete(this.filePath);
        }
        catch (IOException e) {
            throw new WebClientException("Failed to move file from temp to final. Temp: " + this.tempPath.toAbsolutePath() + ", final: " + this.filePath.toAbsolutePath(), e);
        }
    }
}

