/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.webclient.NettyClientHandler;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientServiceResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

class NettyClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final RequestConfiguration configuration;
    private final CompletableFuture<WebClientResponse> future;
    private final CompletableFuture<WebClientServiceResponse> responseReceived;
    private final CompletableFuture<WebClientServiceResponse> requestComplete;

    NettyClientInitializer(RequestConfiguration configuration, CompletableFuture<WebClientResponse> future, CompletableFuture<WebClientServiceResponse> responseReceived, CompletableFuture<WebClientServiceResponse> requestComplete) {
        this.configuration = configuration;
        this.future = future;
        this.responseReceived = responseReceived;
        this.requestComplete = requestComplete;
    }

    protected void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        URI address = this.configuration.requestURI();
        Duration readTimeout = this.configuration.readTimout();
        pipeline.addLast("readTimeout", (ChannelHandler)new ReadTimeoutHandler(readTimeout.toMillis(), TimeUnit.MILLISECONDS));
        this.configuration.proxy().flatMap(proxy -> proxy.handler(address)).ifPresent(it -> {
            ProxyHandler proxyHandler = (ProxyHandler)it;
            proxyHandler.setConnectTimeoutMillis(this.configuration.connectTimeout().toMillis());
            pipeline.addLast(new ChannelHandler[]{proxyHandler});
        });
        if (address.toString().startsWith("https")) {
            this.configuration.sslContext().ifPresent(ctx -> {
                SslHandler sslHandler = ctx.newHandler(channel.alloc(), address.getHost(), address.getPort());
                if (!this.configuration.tls().disableHostnameVerification()) {
                    SSLEngine sslEngine = sslHandler.engine();
                    SSLParameters sslParameters = sslEngine.getSSLParameters();
                    sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                    sslEngine.setSSLParameters(sslParameters);
                }
                pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                sslHandler.handshakeFuture().addListener((GenericFutureListener)((FutureListener)channelFuture -> {
                    if (channelFuture.cause() != null) {
                        this.future.completeExceptionally(channelFuture.cause());
                        channel.close();
                    }
                }));
            });
        }
        pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(LogLevel.TRACE));
        pipeline.addLast("httpCodec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("httpDecompressor", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("helidonHandler", (ChannelHandler)new NettyClientHandler(this.future, this.responseReceived, this.requestComplete));
    }
}

