/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.BufferedEmittingPublisher;
import io.helidon.common.reactive.Single;
import io.helidon.webclient.HttpInterceptor;
import io.helidon.webclient.RedirectInterceptor;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestImpl;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientResponseHeaders;
import io.helidon.webclient.WebClientResponseImpl;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.WebClientServiceResponseImpl;
import io.helidon.webclient.spi.WebClientService;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOGGER = Logger.getLogger(NettyClientHandler.class.getName());
    private static final AttributeKey<WebClientServiceResponse> SERVICE_RESPONSE = AttributeKey.valueOf((String)"response");
    private static final List<HttpInterceptor> HTTP_INTERCEPTORS = new ArrayList<HttpInterceptor>();
    private final WebClientResponseImpl.Builder clientResponse;
    private final CompletableFuture<WebClientResponse> responseFuture;
    private final CompletableFuture<WebClientServiceResponse> responseReceived;
    private final CompletableFuture<WebClientServiceResponse> requestComplete;
    private HttpResponsePublisher publisher;
    private ResponseCloser responseCloser;

    NettyClientHandler(CompletableFuture<WebClientResponse> responseFuture, CompletableFuture<WebClientServiceResponse> responseReceived, CompletableFuture<WebClientServiceResponse> requestComplete) {
        this.responseFuture = responseFuture;
        this.responseReceived = responseReceived;
        this.requestComplete = requestComplete;
        this.clientResponse = WebClientResponseImpl.builder();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        if (this.publisher != null && this.publisher.hasRequests()) {
            ctx.channel().read();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws IOException {
        if (msg instanceof HttpResponse) {
            ctx.channel().config().setAutoRead(false);
            HttpResponse response = (HttpResponse)msg;
            WebClientRequestImpl clientRequest = (WebClientRequestImpl)ctx.channel().attr(WebClientRequestBuilderImpl.REQUEST).get();
            RequestConfiguration requestConfiguration = clientRequest.configuration();
            this.publisher = new HttpResponsePublisher(ctx);
            this.responseCloser = new ResponseCloser(ctx);
            this.clientResponse.contentPublisher((Flow.Publisher<DataChunk>)((Object)this.publisher)).readerContext(requestConfiguration.readerContext()).status(this.helidonStatus(response.status())).httpVersion(Http.Version.create((String)response.protocolVersion().toString())).responseCloser(this.responseCloser).lastEndpointURI(requestConfiguration.requestURI());
            for (HttpInterceptor httpInterceptor : HTTP_INTERCEPTORS) {
                if (!httpInterceptor.shouldIntercept(response.status(), requestConfiguration)) continue;
                httpInterceptor.handleInterception(response, clientRequest, this.responseFuture);
                if (httpInterceptor.continueAfterInterception()) continue;
                this.responseCloser.close().thenAccept(future -> LOGGER.finest(() -> "Response closed due to redirection"));
                return;
            }
            HttpHeaders nettyHeaders = response.headers();
            for (String name : nettyHeaders.names()) {
                List values = nettyHeaders.getAll(name);
                this.clientResponse.addHeader(name, values);
            }
            WebClientResponseImpl webClientResponseImpl = this.clientResponse.build();
            requestConfiguration.cookieManager().put(requestConfiguration.requestURI(), webClientResponseImpl.headers().toMap());
            WebClientServiceResponseImpl clientServiceResponse = new WebClientServiceResponseImpl(requestConfiguration.context().get(), webClientResponseImpl.headers(), webClientResponseImpl.status());
            ctx.channel().attr(SERVICE_RESPONSE).set((Object)clientServiceResponse);
            List<WebClientService> services = requestConfiguration.services();
            CompletionStage<WebClientServiceResponseImpl> csr = CompletableFuture.completedFuture(clientServiceResponse);
            for (WebClientService service : services) {
                csr = csr.thenCompose(clientSerResponse -> service.response(clientRequest, (WebClientServiceResponse)clientSerResponse));
            }
            csr.whenComplete((clientSerResponse, throwable) -> {
                if (throwable != null) {
                    this.responseReceived.completeExceptionally((Throwable)throwable);
                    this.responseFuture.completeExceptionally((Throwable)throwable);
                    this.responseCloser.close();
                } else {
                    this.responseReceived.complete(clientServiceResponse);
                    this.responseReceived.thenRun(() -> {
                        this.responseFuture.complete(clientResponse);
                        if (this.shouldResponseAutomaticallyClose(clientResponse)) {
                            this.responseCloser.close().thenAccept(aVoid -> LOGGER.finest(() -> "Response automatically closed. No entity expected"));
                        }
                    });
                }
            });
        }
        if (this.responseCloser.isClosed()) {
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.publisher.emit(content.content());
        }
        if (msg instanceof LastHttpContent) {
            this.responseCloser.close();
        }
    }

    private boolean shouldResponseAutomaticallyClose(WebClientResponse clientResponse) {
        WebClientResponseHeaders headers = clientResponse.headers();
        if (clientResponse.status() == Http.Status.NO_CONTENT_204) {
            return true;
        }
        return headers.contentType().isEmpty() && this.noContentLength(headers) && this.notChunked(headers);
    }

    private boolean noContentLength(WebClientResponseHeaders headers) {
        return headers.first("Content-Length").isEmpty() || ((String)headers.first("Content-Length").get()).equals("0");
    }

    private boolean notChunked(WebClientResponseHeaders headers) {
        return headers.first("Transfer-Encoding").isEmpty();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.responseFuture.isDone()) {
            this.publisher.fail(cause);
        } else {
            this.responseFuture.completeExceptionally(cause);
        }
        ctx.close();
    }

    private Http.ResponseStatus helidonStatus(final HttpResponseStatus nettyStatus) {
        final int statusCode = nettyStatus.code();
        Optional status = Http.Status.find((int)statusCode);
        if (status.isPresent()) {
            return (Http.ResponseStatus)status.get();
        }
        return new Http.ResponseStatus(){

            public int code() {
                return statusCode;
            }

            public Http.ResponseStatus.Family family() {
                return Http.ResponseStatus.Family.of((int)statusCode);
            }

            public String reasonPhrase() {
                return nettyStatus.reasonPhrase();
            }
        };
    }

    static {
        HTTP_INTERCEPTORS.add(new RedirectInterceptor());
    }

    final class ResponseCloser {
        private final AtomicBoolean closed;
        private final ChannelHandlerContext ctx;
        private final CompletableFuture<Void> cf;

        ResponseCloser(ChannelHandlerContext ctx) {
            this.ctx = ctx;
            this.closed = new AtomicBoolean();
            this.cf = new CompletableFuture();
        }

        boolean isClosed() {
            return this.closed.get();
        }

        Single<Void> close() {
            if (this.closed.compareAndSet(false, true)) {
                WebClientServiceResponse clientServiceResponse = (WebClientServiceResponse)this.ctx.channel().attr(SERVICE_RESPONSE).get();
                NettyClientHandler.this.requestComplete.complete(clientServiceResponse);
                NettyClientHandler.this.publisher.complete();
                this.ctx.close().addListener(future -> {
                    if (future.isSuccess()) {
                        LOGGER.finest(() -> "Response from has been closed.");
                        this.cf.complete(null);
                    } else {
                        LOGGER.log(Level.SEVERE, future.cause(), () -> "An exception occurred while closing the response");
                        this.cf.completeExceptionally(future.cause());
                    }
                });
            }
            return Single.create(this.cf, (boolean)true);
        }
    }

    private static final class HttpResponsePublisher
    extends BufferedEmittingPublisher<DataChunk> {
        private final ReentrantReadWriteLock.WriteLock lock = new ReentrantReadWriteLock().writeLock();

        HttpResponsePublisher(ChannelHandlerContext ctx) {
            super.onRequest((n, cnt) -> {
                if (super.isUnbounded()) {
                    ctx.channel().config().setAutoRead(true);
                } else {
                    ctx.channel().config().setAutoRead(false);
                }
                try {
                    this.lock.lock();
                    if (super.hasRequests()) {
                        ctx.channel().read();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        public int emit(ByteBuf buf) {
            buf.retain();
            return super.emit((Object)DataChunk.create((boolean)false, (boolean)true, () -> ((ByteBuf)buf).release(), (ByteBuffer[])new ByteBuffer[]{buf.nioBuffer().asReadOnlyBuffer()}));
        }
    }
}

