/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.spi.WebClientService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class RequestConfiguration
extends WebClientConfiguration {
    private final URI requestURI;
    private final WebClientServiceRequest clientServiceRequest;
    private final List<WebClientService> services;
    private final Set<MessageBodyReader<?>> requestReaders;
    private final Set<MessageBodyWriter<?>> requestWriters;

    private RequestConfiguration(Builder builder) {
        super(builder);
        this.requestURI = builder.requestURI;
        this.clientServiceRequest = builder.clientServiceRequest;
        this.services = builder.services;
        this.requestReaders = builder.requestReaders;
        this.requestWriters = builder.messageBodyWriters;
    }

    URI requestURI() {
        return this.requestURI;
    }

    WebClientServiceRequest clientServiceRequest() {
        return this.clientServiceRequest;
    }

    List<WebClientService> services() {
        return this.services;
    }

    Set<MessageBodyReader<?>> requestReaders() {
        return this.requestReaders;
    }

    Set<MessageBodyWriter<?>> requestWriters() {
        return this.requestWriters;
    }

    static Builder builder(URI requestURI) {
        return new Builder(requestURI);
    }

    static final class Builder
    extends WebClientConfiguration.Builder<Builder, RequestConfiguration> {
        private WebClientServiceRequest clientServiceRequest;
        private URI requestURI;
        private List<WebClientService> services = new ArrayList<WebClientService>();
        private Set<MessageBodyReader<?>> requestReaders;
        private Set<MessageBodyWriter<?>> messageBodyWriters;

        private Builder(URI requestURI) {
            this.requestURI = requestURI;
        }

        Builder clientServiceRequest(WebClientServiceRequest clientServiceRequest) {
            this.clientServiceRequest = clientServiceRequest;
            return this;
        }

        Builder services(List<WebClientService> services) {
            this.services = Collections.unmodifiableList(services);
            return this;
        }

        Builder requestReaders(Set<MessageBodyReader<?>> requestReaders) {
            this.requestReaders = requestReaders;
            return this;
        }

        Builder requestWriters(Set<MessageBodyWriter<?>> messageBodyWriters) {
            this.messageBodyWriters = messageBodyWriters;
            return this;
        }

        @Override
        public RequestConfiguration build() {
            return new RequestConfiguration(this);
        }
    }
}

