/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.webclient.Proxy;
import io.netty.channel.ChannelHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ProxyImpl
implements Proxy {
    private static final Logger LOGGER = Logger.getLogger(ProxyImpl.class.getName());
    private static final Pattern PORT_PATTERN = Pattern.compile(".*:(\\d+)");
    private static final Pattern IP_V4 = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IP_V6_IDENTIFIER = Pattern.compile("^\\[(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}]$");
    private static final Pattern IP_V6_HEX_IDENTIFIER = Pattern.compile("^\\[((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)]$");
    private static final Pattern IP_V6_HOST = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IP_V6_HEX_HOST = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private final Proxy.ProxyType type;
    private final String host;
    private final int port;
    private final Function<URI, Boolean> noProxy;
    private final Optional<String> username;
    private final Optional<char[]> password;
    private final ProxySelector systemSelector;
    private final boolean useSystemSelector;

    ProxyImpl(Proxy.Builder builder) {
        this.type = builder.type();
        this.systemSelector = builder.systemSelector();
        this.host = builder.host();
        this.useSystemSelector = null == this.host && null != this.systemSelector;
        this.port = builder.port();
        this.username = builder.username();
        this.password = builder.password();
        this.noProxy = this.useSystemSelector ? inetSocketAddress -> true : ProxyImpl.prepareNoProxy(builder.noProxyHosts());
    }

    @Override
    public Optional<ChannelHandler> handler(URI address) {
        if (this.type == Proxy.ProxyType.NONE) {
            return Optional.empty();
        }
        if (this.useSystemSelector) {
            return this.systemSelectorHandler(address);
        }
        if (this.noProxy.apply(address).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(this.handler());
    }

    static Function<URI, Boolean> prepareNoProxy(Set<String> noProxyHosts) {
        if (noProxyHosts.isEmpty()) {
            return address -> false;
        }
        boolean simple = true;
        for (String noProxyHost : noProxyHosts) {
            if (!noProxyHost.startsWith(".")) continue;
            simple = false;
            break;
        }
        if (simple) {
            return address -> noProxyHosts.contains(address.getHost()) || noProxyHosts.contains(address.getHost() + ":" + address.getPort());
        }
        LinkedList<BiFunction<String, Integer, Boolean>> hostMatchers = new LinkedList<BiFunction<String, Integer, Boolean>>();
        LinkedList<BiFunction<String, Integer, Boolean>> ipMatchers = new LinkedList<BiFunction<String, Integer, Boolean>>();
        Iterator<String> iterator = noProxyHosts.iterator();
        while (iterator.hasNext()) {
            String noProxyHost;
            String hostPart = noProxyHost = iterator.next();
            Integer portPart = null;
            Matcher portMatcher = PORT_PATTERN.matcher(noProxyHost);
            if (portMatcher.matches()) {
                portPart = Integer.parseInt(portMatcher.group(1));
                int index = noProxyHost.lastIndexOf(58);
                hostPart = noProxyHost.substring(0, index);
            }
            if (ProxyImpl.isIpV4(hostPart)) {
                ProxyImpl.exactMatch(ipMatchers, hostPart, portPart);
                continue;
            }
            if (ProxyImpl.isIpV6Identifier(hostPart)) {
                if ("[::1]".equals(hostPart)) {
                    ProxyImpl.exactMatch(ipMatchers, "0:0:0:0:0:0:0:1", portPart);
                }
                ProxyImpl.exactMatch(ipMatchers, hostPart.substring(1, hostPart.length() - 1), portPart);
                continue;
            }
            if (hostPart.charAt(0) == '.') {
                ProxyImpl.prefixedMatch(hostMatchers, hostPart, portPart);
                continue;
            }
            ProxyImpl.exactMatch(hostMatchers, hostPart, portPart);
        }
        return address -> {
            String host = address.getHost();
            int port = address.getPort();
            if (ProxyImpl.isIpV4(host) || ProxyImpl.isIpV6Host(host)) {
                for (BiFunction ipMatcher : ipMatchers) {
                    if (!((Boolean)ipMatcher.apply(host, port)).booleanValue()) continue;
                    LOGGER.finest(() -> "IP Address " + host + " bypasses proxy");
                    return true;
                }
                LOGGER.finest(() -> "IP Address " + host + " uses proxy");
            } else {
                for (BiFunction hostMatcher : hostMatchers) {
                    if (!((Boolean)hostMatcher.apply(host, port)).booleanValue()) continue;
                    LOGGER.finest(() -> "Host " + host + " bypasses proxy");
                    return true;
                }
                LOGGER.finest(() -> "Host " + host + " uses proxy");
            }
            return false;
        };
    }

    private static void prefixedMatch(List<BiFunction<String, Integer, Boolean>> matchers, String hostPart, Integer portPart) {
        if (null == portPart) {
            matchers.add((host, port) -> ProxyImpl.prefixHostMatch(hostPart, host));
        } else {
            matchers.add((host, port) -> portPart.equals(port) && ProxyImpl.prefixHostMatch(hostPart, host));
        }
    }

    private static boolean prefixHostMatch(String hostPart, String host) {
        if (host.endsWith(hostPart)) {
            return true;
        }
        return host.equals(hostPart.substring(1));
    }

    private static void exactMatch(List<BiFunction<String, Integer, Boolean>> matchers, String hostPart, Integer portPart) {
        if (null == portPart) {
            matchers.add((host, port) -> hostPart.equals(host));
        } else {
            matchers.add((host, port) -> portPart.equals(port) && hostPart.equals(host));
        }
    }

    private static boolean isIpV4(String host) {
        return IP_V4.matcher(host).matches();
    }

    private static boolean isIpV6Identifier(String host) {
        return IP_V6_IDENTIFIER.matcher(host).matches() || IP_V6_HEX_IDENTIFIER.matcher(host).matches();
    }

    private static boolean isIpV6Host(String host) {
        return IP_V6_HOST.matcher(host).matches() || IP_V6_HEX_HOST.matcher(host).matches();
    }

    private Optional<ChannelHandler> systemSelectorHandler(URI address) {
        List<java.net.Proxy> selected = this.systemSelector.select(URI.create("http://" + address.getHost() + ":" + address.getPort()));
        if (selected.isEmpty()) {
            return Optional.empty();
        }
        java.net.Proxy systemProxy = selected.iterator().next();
        switch (systemProxy.type()) {
            case DIRECT: {
                return Optional.empty();
            }
            case HTTP: {
                return Optional.of(this.httpProxy(systemProxy));
            }
            case SOCKS: {
                return Optional.of(this.socksProxy(systemProxy));
            }
        }
        throw new IllegalStateException("Unexpected proxy type: " + systemProxy.type());
    }

    private ChannelHandler handler() {
        switch (this.type) {
            case HTTP: {
                return this.httpProxy();
            }
            case SOCKS_4: {
                return this.socks4Proxy();
            }
            case SOCKS_5: {
                return this.socks5Proxy();
            }
        }
        throw new IllegalArgumentException("Unsupported proxy type: " + this.type);
    }

    private ChannelHandler socks5Proxy() {
        if (this.username.isPresent()) {
            return new Socks5ProxyHandler((SocketAddress)this.address(), this.username.get(), this.password.map(String::new).orElse(""));
        }
        return new Socks5ProxyHandler((SocketAddress)this.address());
    }

    private ChannelHandler socks4Proxy() {
        if (this.username.isPresent()) {
            return new Socks4ProxyHandler((SocketAddress)this.address(), this.username.get());
        }
        return new Socks4ProxyHandler((SocketAddress)this.address());
    }

    private ChannelHandler httpProxy() {
        if (this.username.isPresent()) {
            return new HttpProxyHandler((SocketAddress)this.address(), this.username.get(), this.password.map(String::new).orElse(""));
        }
        return new HttpProxyHandler((SocketAddress)this.address());
    }

    private ChannelHandler httpProxy(java.net.Proxy systemProxy) {
        return new HttpProxyHandler(systemProxy.address());
    }

    private ChannelHandler socksProxy(java.net.Proxy systemProxy) {
        return new Socks5ProxyHandler(systemProxy.address());
    }

    private InetSocketAddress address() {
        return new InetSocketAddress(this.host, this.port);
    }
}

