/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.OriginThreadPublisher;
import io.helidon.webclient.HttpInterceptor;
import io.helidon.webclient.RedirectInterceptor;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientResponseHeaders;
import io.helidon.webclient.WebClientResponseImpl;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.WebClientServiceResponseImpl;
import io.helidon.webclient.spi.WebClientService;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

class NettyClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOGGER = Logger.getLogger(NettyClientHandler.class.getName());
    private static final AttributeKey<WebClientServiceResponse> SERVICE_RESPONSE = AttributeKey.valueOf((String)"response");
    private static final List<HttpInterceptor> HTTP_INTERCEPTORS = new ArrayList<HttpInterceptor>();
    private final WebClientResponseImpl.Builder clientResponse;
    private final CompletableFuture<WebClientResponse> responseFuture;
    private final CompletableFuture<WebClientServiceResponse> responseReceived;
    private final CompletableFuture<WebClientServiceResponse> requestComplete;
    private HttpResponsePublisher publisher;
    private ResponseCloser responseCloser;

    NettyClientHandler(CompletableFuture<WebClientResponse> responseFuture, CompletableFuture<WebClientServiceResponse> responseReceived, CompletableFuture<WebClientServiceResponse> requestComplete) {
        this.responseFuture = responseFuture;
        this.responseReceived = responseReceived;
        this.requestComplete = requestComplete;
        this.clientResponse = WebClientResponseImpl.builder();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        if (this.publisher != null && this.publisher.tryAcquire() > 0L) {
            ctx.channel().read();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws IOException {
        if (msg instanceof HttpResponse) {
            ctx.channel().config().setAutoRead(false);
            HttpResponse response = (HttpResponse)msg;
            WebClientRequestBuilder.ClientRequest clientRequest = (WebClientRequestBuilder.ClientRequest)ctx.channel().attr(WebClientRequestBuilderImpl.REQUEST).get();
            RequestConfiguration requestConfiguration = clientRequest.configuration();
            this.publisher = new HttpResponsePublisher(ctx);
            this.responseCloser = new ResponseCloser(ctx);
            this.clientResponse.contentPublisher((Flow.Publisher<DataChunk>)((Object)this.publisher)).mediaSupport(requestConfiguration.mediaSupport()).requestBodyReaders(requestConfiguration.requestReaders()).status(this.helidonStatus(response.status())).httpVersion(Http.Version.create((String)response.protocolVersion().toString())).responseCloser(this.responseCloser);
            for (HttpInterceptor httpInterceptor : HTTP_INTERCEPTORS) {
                if (!httpInterceptor.shouldIntercept(response.status(), requestConfiguration)) continue;
                httpInterceptor.handleInterception(response, clientRequest, this.responseFuture);
                if (httpInterceptor.continueAfterInterception()) continue;
                this.responseCloser.close().addListener(future -> LOGGER.finest("Response closed due to redirection"));
                return;
            }
            HttpHeaders nettyHeaders = response.headers();
            for (String name : nettyHeaders.names()) {
                List values = nettyHeaders.getAll(name);
                this.clientResponse.addHeader(name, values);
            }
            WebClientResponseImpl webClientResponseImpl = this.clientResponse.build();
            requestConfiguration.cookieManager().put(requestConfiguration.requestURI(), webClientResponseImpl.headers().toMap());
            WebClientServiceResponseImpl clientServiceResponse = new WebClientServiceResponseImpl(requestConfiguration.context().get(), webClientResponseImpl.headers(), webClientResponseImpl.status());
            ctx.channel().attr(SERVICE_RESPONSE).set((Object)clientServiceResponse);
            List<WebClientService> services = requestConfiguration.services();
            CompletionStage<WebClientServiceResponseImpl> csr = CompletableFuture.completedFuture(clientServiceResponse);
            for (WebClientService service : services) {
                csr = csr.thenCompose(clientSerResponse -> service.response(clientRequest, (WebClientServiceResponse)clientSerResponse));
            }
            csr.whenComplete((clientSerResponse, throwable) -> {
                this.responseReceived.complete(clientServiceResponse);
                if (this.shouldResponseAutomaticallyClose(clientResponse)) {
                    this.responseCloser.close().addListener(future -> {
                        LOGGER.finest("Response automatically closed. No entity expected.");
                        this.responseFuture.complete(clientResponse);
                    });
                } else {
                    this.responseFuture.complete(clientResponse);
                }
            });
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.publisher.submit(content.content());
        }
        if (msg instanceof LastHttpContent && !this.responseCloser.isClosed()) {
            this.responseCloser.close();
        }
    }

    private boolean shouldResponseAutomaticallyClose(WebClientResponse clientResponse) {
        WebClientResponseHeaders headers = clientResponse.headers();
        if (clientResponse.status() == Http.Status.NO_CONTENT_204) {
            return true;
        }
        return headers.contentType().isEmpty() && (headers.first("Content-Length").isEmpty() || ((String)headers.first("Content-Length").get()).equals("0"));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.responseFuture.isDone()) {
            this.publisher.error(cause);
        } else {
            this.responseFuture.completeExceptionally(cause);
        }
        ctx.close();
    }

    private Http.ResponseStatus helidonStatus(final HttpResponseStatus nettyStatus) {
        final int statusCode = nettyStatus.code();
        Optional status = Http.Status.find((int)statusCode);
        if (status.isPresent()) {
            return (Http.ResponseStatus)status.get();
        }
        return new Http.ResponseStatus(){

            public int code() {
                return statusCode;
            }

            public Http.ResponseStatus.Family family() {
                return Http.ResponseStatus.Family.of((int)statusCode);
            }

            public String reasonPhrase() {
                return nettyStatus.reasonPhrase();
            }
        };
    }

    static {
        HTTP_INTERCEPTORS.add(new RedirectInterceptor());
    }

    final class ResponseCloser {
        private final AtomicBoolean closed;
        private final ChannelHandlerContext ctx;

        ResponseCloser(ChannelHandlerContext ctx) {
            this.ctx = ctx;
            this.closed = new AtomicBoolean();
        }

        boolean isClosed() {
            return this.closed.get();
        }

        ChannelFuture close() {
            if (this.closed.compareAndSet(false, true)) {
                WebClientServiceResponse clientServiceResponse = (WebClientServiceResponse)this.ctx.channel().attr(SERVICE_RESPONSE).get();
                NettyClientHandler.this.requestComplete.complete(clientServiceResponse);
                NettyClientHandler.this.publisher.complete();
                return this.ctx.close();
            }
            throw new WebClientException("Response has been already closed!");
        }
    }

    private static final class HttpResponsePublisher
    extends OriginThreadPublisher<DataChunk, ByteBuf> {
        private final ReentrantReadWriteLock.WriteLock lock = new ReentrantReadWriteLock().writeLock();
        private final ChannelHandlerContext ctx;

        HttpResponsePublisher(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void hookOnRequested(long n, long result) {
            if (result == Long.MAX_VALUE) {
                this.ctx.channel().config().setAutoRead(true);
            } else {
                this.ctx.channel().config().setAutoRead(false);
            }
            try {
                this.lock.lock();
                if (super.tryAcquire() > 0L) {
                    this.ctx.channel().read();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public long tryAcquire() {
            try {
                this.lock.lock();
                long l = super.tryAcquire();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected DataChunk wrap(ByteBuf buf) {
            buf.retain();
            return DataChunk.create((boolean)false, (ByteBuffer)buf.nioBuffer().asReadOnlyBuffer(), () -> ((ByteBuf)buf).release(), (boolean)true);
        }
    }
}

