/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.websocket;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.websocket.WsClient;
import io.helidon.webclient.websocket.WsClientConfigBlueprint;
import io.helidon.webclient.websocket.WsClientProtocolConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webclient.websocket.WsClientConfigBlueprint")
public interface WsClientConfig
extends WsClientConfigBlueprint,
Prototype.Api,
HttpClientConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WsClientConfig instance) {
        return (Builder)((Object)WsClientConfig.builder().from(instance));
    }

    public static WsClientConfig create(Config config) {
        return ((Builder)WsClientConfig.builder().config(config)).buildPrototype();
    }

    public static WsClientConfig create() {
        return WsClientConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, WsClientConfig>
    implements io.helidon.common.Builder<Builder, WsClient> {
        private Builder() {
        }

        public WsClientConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WsClientConfigImpl(this);
        }

        public WsClient build() {
            return WsClient.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WsClientConfig>
    extends HttpClientConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private WsClientProtocolConfig protocolConfig = WsClientProtocolConfig.create();

        protected BuilderBase() {
        }

        public BUILDER from(WsClientConfig prototype) {
            super.from((HttpClientConfig)prototype);
            this.protocolConfig(prototype.protocolConfig());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.protocolConfig(builder.protocolConfig());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("protocol-config").map(WsClientProtocolConfig::create).ifPresent(this::protocolConfig);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(WsClientProtocolConfig protocolConfig) {
            Objects.requireNonNull(protocolConfig);
            this.protocolConfig = protocolConfig;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(Consumer<WsClientProtocolConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            WsClientProtocolConfig.Builder builder = WsClientProtocolConfig.builder();
            consumer.accept(builder);
            this.protocolConfig(builder.build());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(Supplier<? extends WsClientProtocolConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.protocolConfig(supplier.get());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public WsClientProtocolConfig protocolConfig() {
            return this.protocolConfig;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "WsClientConfigBuilder{protocolConfig=" + String.valueOf(this.protocolConfig) + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        protected void validatePrototype() {
            super.validatePrototype();
        }

        protected static class WsClientConfigImpl
        extends HttpClientConfig.BuilderBase.HttpClientConfigImpl
        implements WsClientConfig,
        Supplier<WsClient> {
            private final WsClientProtocolConfig protocolConfig;

            protected WsClientConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.protocolConfig = builder.protocolConfig();
            }

            public WsClient build() {
                return WsClient.create(this);
            }

            @Override
            public WsClient get() {
                return this.build();
            }

            @Override
            public WsClientProtocolConfig protocolConfig() {
                return this.protocolConfig;
            }

            public String toString() {
                return "WsClientConfig{protocolConfig=" + String.valueOf(this.protocolConfig) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WsClientConfig)) {
                    return false;
                }
                WsClientConfig other = (WsClientConfig)o;
                return super.equals((Object)other) && Objects.equals(this.protocolConfig, other.protocolConfig());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.protocolConfig);
            }
        }
    }
}

