/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.websocket;

import io.helidon.common.LazyValue;
import io.helidon.common.socket.SocketContext;
import io.helidon.common.uri.UriInfo;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.UpgradeResponse;
import io.helidon.webclient.websocket.ClientWsConnection;
import io.helidon.webclient.websocket.WsClient;
import io.helidon.webclient.websocket.WsClientConfig;
import io.helidon.webclient.websocket.WsClientException;
import io.helidon.websocket.WsListener;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import java.util.Set;

class WsClientImpl
implements WsClient {
    static final String SUPPORTED_VERSION = "13";
    static final Http.Header HEADER_UPGRADE_WS = Http.Headers.createCached((Http.HeaderName)Http.HeaderNames.UPGRADE, (String)"websocket");
    static final Http.HeaderName HEADER_WS_PROTOCOL = Http.HeaderNames.create((String)"Sec-WebSocket-Protocol");
    private static final Http.Header HEADER_WS_VERSION = Http.Headers.createCached((Http.HeaderName)Http.HeaderNames.create((String)"Sec-WebSocket-Version"), (String)"13");
    private static final System.Logger LOGGER = System.getLogger(WsClient.class.getName());
    private static final Http.Header HEADER_CONN_UPGRADE = Http.Headers.create((Http.HeaderName)Http.HeaderNames.CONNECTION, (String)"Upgrade");
    private static final Http.HeaderName HEADER_WS_ACCEPT = Http.HeaderNames.create((String)"Sec-WebSocket-Accept");
    private static final Http.HeaderName HEADER_WS_KEY = Http.HeaderNames.create((String)"Sec-WebSocket-Key");
    private static final LazyValue<Random> RANDOM = LazyValue.create(SecureRandom::new);
    private static final byte[] KEY_SUFFIX = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.US_ASCII);
    private static final int KEY_SUFFIX_LENGTH = KEY_SUFFIX.length;
    private static final Base64.Encoder B64_ENCODER = Base64.getEncoder();
    private static final Set<String> SUPPORTED_SCHEMES = Set.of("wss", "ws", "https", "http");
    private final ClientRequestHeaders headers;
    private final WebClient webClient;
    private final Http1Client http1Client;
    private final WsClientConfig clientConfig;

    WsClientImpl(WebClient webClient, Http1Client http1Client, WsClientConfig clientConfig) {
        this.webClient = webClient;
        this.http1Client = http1Client;
        this.clientConfig = clientConfig;
        ClientRequestHeaders headers = ((Http1ClientConfig)http1Client.prototype()).defaultRequestHeaders();
        headers.set(HEADER_UPGRADE_WS);
        headers.set(HEADER_WS_VERSION);
        headers.set(Http.Headers.CONTENT_LENGTH_ZERO);
        if (clientConfig.protocolConfig().subProtocols().isEmpty()) {
            headers.remove(HEADER_WS_PROTOCOL);
        } else {
            headers.set(HEADER_WS_PROTOCOL, clientConfig.protocolConfig().subProtocols());
        }
        this.headers = headers;
    }

    @Override
    public void connect(URI uri, WsListener listener) {
        ClientWsConnection session;
        byte[] nonce = new byte[16];
        ((Random)RANDOM.get()).nextBytes(nonce);
        String secWsKey = B64_ENCODER.encodeToString(nonce);
        Http1ClientRequest upgradeRequest = (Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)this.http1Client.get()).headers((Headers)this.headers)).header(HEADER_WS_KEY, new String[]{secWsKey})).uri(uri);
        UriInfo resolvedUri = upgradeRequest.resolvedUri();
        String scheme = resolvedUri.scheme();
        if (!SUPPORTED_SCHEMES.contains(scheme)) {
            throw new IllegalArgumentException(String.format("Not supported scheme %s, web socket client supported schemes are: %s", scheme, String.join((CharSequence)", ", SUPPORTED_SCHEMES)));
        }
        if ("ws".equals(scheme)) {
            upgradeRequest.uri(ClientUri.create((UriInfo)resolvedUri).scheme("http"));
        } else if ("wss".equals(scheme)) {
            upgradeRequest.uri(ClientUri.create((UriInfo)resolvedUri).scheme("https"));
        }
        upgradeRequest.headers(headers -> headers.setIfAbsent(Http.Headers.create((Http.HeaderName)Http.HeaderNames.HOST, (String)resolvedUri.authority())));
        UpgradeResponse upgradeResponse = upgradeRequest.upgrade("websocket");
        if (!upgradeResponse.isUpgraded()) {
            throw new WsClientException("Failed to upgrade to WebSocket. Response: " + String.valueOf(upgradeResponse));
        }
        try (HttpClientResponse response = upgradeResponse.response();){
            ClientResponseHeaders responseHeaders = response.headers();
            if (!responseHeaders.contains(HEADER_CONN_UPGRADE)) {
                throw new WsClientException("Failed to upgrade to WebSocket, expected Connection: Upgrade header. Headers: " + String.valueOf(responseHeaders));
            }
            if (!responseHeaders.contains(HEADER_UPGRADE_WS)) {
                throw new WsClientException("Failed to upgrade to WebSocket, expected Upgrade: websocket header. Headers: " + String.valueOf(responseHeaders));
            }
            if (!responseHeaders.contains(HEADER_WS_ACCEPT)) {
                throw new WsClientException("Failed to upgrade to WebSocket, expected Sec-WebSocket-Accept header. Headers: " + String.valueOf(responseHeaders));
            }
            ClientConnection connection = upgradeResponse.connection();
            String secWsAccept = responseHeaders.get(HEADER_WS_ACCEPT).value();
            if (!this.hash((SocketContext)connection.helidonSocket(), secWsKey).equals(secWsAccept)) {
                throw new WsClientException("Failed to upgrade to WebSocket, expected valid secWsKey. Headers: " + String.valueOf(responseHeaders));
            }
            session = this.headers.contains(HEADER_WS_PROTOCOL) ? new ClientWsConnection(connection, listener, this.headers.get(HEADER_WS_PROTOCOL).value()) : new ClientWsConnection(connection, listener);
        }
        this.webClient.executor().submit(session);
    }

    @Override
    public void connect(String path, WsListener listener) {
        this.connect(URI.create(path), listener);
    }

    public WsClientConfig prototype() {
        return this.clientConfig;
    }

    protected String hash(SocketContext ctx, String wsKey) {
        byte[] wsKeyBytes = wsKey.getBytes(StandardCharsets.US_ASCII);
        int wsKeyBytesLength = wsKeyBytes.length;
        byte[] toHash = new byte[wsKeyBytesLength + KEY_SUFFIX_LENGTH];
        System.arraycopy(wsKeyBytes, 0, toHash, 0, wsKeyBytesLength);
        System.arraycopy(KEY_SUFFIX, 0, toHash, wsKeyBytesLength, KEY_SUFFIX_LENGTH);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return B64_ENCODER.encodeToString(digest.digest(toHash));
        }
        catch (NoSuchAlgorithmException e) {
            ctx.log(LOGGER, System.Logger.Level.ERROR, "SHA-1 must be provided for WebSocket to work", (Throwable)e, new Object[0]);
            throw new IllegalStateException("SHA-1 not provided", e);
        }
    }
}

